/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Producer;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.core.xml.CamelProxyFactoryDefinition;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

final class XmlProxyFactoryBean<T>
extends SyntheticBean<T> {
    private final BeanManager manager;
    private final Bean<?> context;
    private final CamelProxyFactoryDefinition proxy;

    XmlProxyFactoryBean(BeanManager manager, SyntheticAnnotated annotated, Class<?> type, Function<Bean<T>, String> toString, Bean<?> context, CamelProxyFactoryDefinition proxy) {
        super(manager, annotated, type, null, toString);
        this.manager = manager;
        this.context = context;
        this.proxy = proxy;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            CamelContext context;
            CamelContext camelContext = context = ObjectHelper.isNotEmpty((Object)this.proxy.getCamelContextId()) ? BeanManagerHelper.getReferenceByName(this.manager, this.proxy.getCamelContextId(), CamelContext.class).get() : BeanManagerHelper.getReference(this.manager, CamelContext.class, this.context);
            if (!ObjectHelper.isNotEmpty((Object)this.proxy.getServiceUrl())) {
                throw new IllegalStateException("serviceUrl must not be empty!");
            }
            Endpoint endpoint = context.getEndpoint(this.proxy.getServiceUrl());
            if (endpoint == null) {
                throw new UnsatisfiedResolutionException("Could not resolve endpoint: " + this.proxy.getServiceUrl());
            }
            try {
                ServiceHelper.startService((Object)endpoint);
                Producer producer = endpoint.createProducer();
                context.addService((Object)producer, true, true);
                return (T)ProxyHelper.createProxy((Endpoint)endpoint, (boolean)true, (Producer)producer, (Class[])new Class[]{this.proxy.getServiceInterface()});
            }
            catch (Exception cause) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)cause);
            }
        }
        catch (Exception cause) {
            throw new CreationException("Error while creating instance for " + this, (Throwable)cause);
        }
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }
}

