/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.sparkrest.SparkMessage;
import org.apache.camel.spi.TypeConverterRegistry;
import spark.Request;
import spark.Response;

@Converter(generateLoader=true)
public final class SparkConverter {
    private SparkConverter() {
    }

    @Converter(fallback=true)
    public static Object convertToRequest(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        SparkMessage msg;
        if (value != null && Request.class.isAssignableFrom(type) && (msg = exchange.hasOut() ? (SparkMessage)((Object)exchange.getOut(SparkMessage.class)) : (SparkMessage)((Object)exchange.getIn(SparkMessage.class))) != null) {
            return msg.getRequest();
        }
        return null;
    }

    @Converter(fallback=true)
    public static Object convertToResponse(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        SparkMessage msg;
        if (value != null && Response.class.isAssignableFrom(type) && (msg = exchange.hasOut() ? (SparkMessage)((Object)exchange.getOut(SparkMessage.class)) : (SparkMessage)((Object)exchange.getIn(SparkMessage.class))) != null) {
            return msg.getResponse();
        }
        return null;
    }
}

