/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.wordpress.WordpressComponentConfiguration;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;

@Component(value="wordpress")
public class WordpressComponent
extends DefaultComponent {
    private static final String OP_SEPARATOR = ":";
    @Metadata(label="advanced", description="Wordpress component configuration")
    private WordpressComponentConfiguration configuration;

    public WordpressComponent() {
        this(new WordpressComponentConfiguration());
    }

    public WordpressComponent(WordpressComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    public WordpressComponent(CamelContext camelContext) {
        super(camelContext);
        this.configuration = new WordpressComponentConfiguration();
    }

    public WordpressComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WordpressComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WordpressComponentConfiguration endpointConfiguration = this.copyComponentProperties();
        WordpressEndpoint endpoint = new WordpressEndpoint(uri, this, endpointConfiguration);
        this.setProperties((Object)endpoint, parameters);
        this.discoverOperations(endpoint, remaining);
        endpoint.configureProperties(parameters);
        return endpoint;
    }

    private void discoverOperations(WordpressEndpoint endpoint, String remaining) {
        String[] operations = remaining.split(OP_SEPARATOR);
        endpoint.setOperation(operations[0]);
        if (operations.length > 1) {
            endpoint.setOperationDetail(operations[1]);
        }
    }

    private WordpressComponentConfiguration copyComponentProperties() throws Exception {
        HashMap componentProperties = new HashMap();
        if (this.configuration != null) {
            BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection();
            beanIntrospection.getProperties((Object)this.configuration, componentProperties, null, false);
        }
        WordpressComponentConfiguration config = new WordpressComponentConfiguration();
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)config, componentProperties);
        return config;
    }
}

