/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.netty.NegotiationType;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConsumerStrategy;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcProducerStrategy;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class GrpcEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return GrpcEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return GrpcEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "method": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMethod((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "negotiationType": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setNegotiationType((NegotiationType)GrpcEndpointConfigurer.property((CamelContext)camelContext, NegotiationType.class, (Object)value));
                return true;
            }
            case "authenticationType": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setAuthenticationType((GrpcAuthType)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcAuthType.class, (Object)value)));
                return true;
            }
            case "jwtAlgorithm": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtAlgorithm((JwtAlgorithm)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, JwtAlgorithm.class, (Object)value)));
                return true;
            }
            case "jwtSecret": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtSecret((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "jwtIssuer": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtIssuer((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "jwtSubject": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtSubject((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serviceAccountResource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setServiceAccountResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyCertChainResource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyCertChainResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyResource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyPassword": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyPassword((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustCertCollectionResource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setTrustCertCollectionResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producerStrategy": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setProducerStrategy((GrpcProducerStrategy)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcProducerStrategy.class, (Object)value)));
                return true;
            }
            case "streamRepliesTo": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setStreamRepliesTo((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "userAgent": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setUserAgent((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerStrategy": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setConsumerStrategy((GrpcConsumerStrategy)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcConsumerStrategy.class, (Object)value)));
                return true;
            }
            case "forwardOnCompleted": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setForwardOnCompleted((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forwardOnError": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setForwardOnError((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "flowControlWindow": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setFlowControlWindow((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxMessageSize": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMaxMessageSize((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxConcurrentCallsPerConnection": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMaxConcurrentCallsPerConnection((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((GrpcEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((GrpcEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((GrpcEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)GrpcEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((GrpcEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)GrpcEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((GrpcEndpoint)((Object)endpoint)).setSynchronous((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((GrpcEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "method": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMethod((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "negotiationtype": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setNegotiationType((NegotiationType)GrpcEndpointConfigurer.property((CamelContext)camelContext, NegotiationType.class, (Object)value));
                return true;
            }
            case "authenticationtype": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setAuthenticationType((GrpcAuthType)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcAuthType.class, (Object)value)));
                return true;
            }
            case "jwtalgorithm": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtAlgorithm((JwtAlgorithm)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, JwtAlgorithm.class, (Object)value)));
                return true;
            }
            case "jwtsecret": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtSecret((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "jwtissuer": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtIssuer((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "jwtsubject": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setJwtSubject((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serviceaccountresource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setServiceAccountResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keycertchainresource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyCertChainResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyresource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keypassword": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setKeyPassword((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustcertcollectionresource": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setTrustCertCollectionResource((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producerstrategy": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setProducerStrategy((GrpcProducerStrategy)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcProducerStrategy.class, (Object)value)));
                return true;
            }
            case "streamrepliesto": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setStreamRepliesTo((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useragent": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setUserAgent((String)GrpcEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerstrategy": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setConsumerStrategy((GrpcConsumerStrategy)((Object)GrpcEndpointConfigurer.property((CamelContext)camelContext, GrpcConsumerStrategy.class, (Object)value)));
                return true;
            }
            case "forwardoncompleted": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setForwardOnCompleted((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forwardonerror": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setForwardOnError((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "flowcontrolwindow": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setFlowControlWindow((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxmessagesize": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMaxMessageSize((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxconcurrentcallsperconnection": {
                ((GrpcEndpoint)((Object)endpoint)).getConfiguration().setMaxConcurrentCallsPerConnection((Integer)GrpcEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((GrpcEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((GrpcEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((GrpcEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)GrpcEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((GrpcEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)GrpcEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((GrpcEndpoint)((Object)endpoint)).setSynchronous((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((GrpcEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)GrpcEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

