/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.apns.factory;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.ReconnectPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.apns.model.ConnectionStrategy;
import org.apache.camel.component.apns.model.ReconnectionPolicy;
import org.apache.camel.component.apns.util.AssertUtils;
import org.apache.camel.component.apns.util.ParamUtils;
import org.apache.camel.component.apns.util.ResourceUtils;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class ApnsServiceFactory
implements CamelContextAware {
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int MIN_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 30;
    private CamelContext camelContext;
    private String certificatePath;
    private String certificatePassword;
    private ConnectionStrategy connectionStrategy;
    private ReconnectionPolicy reconnectionPolicy;
    private SSLContextParameters sslContextParameters;
    private int poolSize = 10;
    private String gatewayHost = "gateway.push.apple.com";
    private int gatewayPort = 2195;
    private String feedbackHost = "feedback.push.apple.com";
    private int feedbackPort = 2196;
    private ApnsDelegate apnsDelegate;

    public ApnsServiceFactory() {
    }

    public ApnsServiceFactory(CamelContext camelContext) {
        this();
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getFeedbackHost() {
        return this.feedbackHost;
    }

    public void setFeedbackHost(String feedbackHost) {
        this.feedbackHost = feedbackHost;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public void setGatewayPort(int gatewayPort) {
        this.gatewayPort = gatewayPort;
    }

    public int getFeedbackPort() {
        return this.feedbackPort;
    }

    public void setFeedbackPort(int feedbackPort) {
        this.feedbackPort = feedbackPort;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public ReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public ApnsDelegate getApnsDelegate() {
        return this.apnsDelegate;
    }

    public void setApnsDelegate(ApnsDelegate apnsDelegate) {
        this.apnsDelegate = apnsDelegate;
    }

    public ApnsService getApnsService() {
        ApnsServiceBuilder builder = APNS.newService();
        builder = this.configureServiceBuilder(builder);
        this.configureConnectionStrategy(builder);
        this.configureReconnectionPolicy(builder);
        this.configureApnsDelegate(builder);
        this.configureApnsDestinations(builder);
        try {
            this.configureApnsCertificate(builder);
        }
        catch (IOException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        ApnsService apnsService = builder.build();
        return apnsService;
    }

    protected ApnsServiceBuilder configureServiceBuilder(ApnsServiceBuilder serviceBuilder) {
        return serviceBuilder;
    }

    private void configureApnsCertificate(ApnsServiceBuilder builder) throws IOException, GeneralSecurityException {
        if (this.getSslContextParameters() != null) {
            builder.withSSLContext(this.getSslContextParameters().createSSLContext(this.getCamelContext()));
            return;
        }
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        StringHelper.notEmpty((String)this.getCertificatePath(), (String)"certificatePath");
        StringHelper.notEmpty((String)this.getCertificatePassword(), (String)"certificatePassword");
        InputStream certificateInputStream = null;
        try {
            certificateInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)this.getCertificatePath());
            builder.withCert(certificateInputStream, this.getCertificatePassword());
        }
        catch (Throwable throwable) {
            ResourceUtils.close(certificateInputStream);
            throw throwable;
        }
        ResourceUtils.close(certificateInputStream);
    }

    private void configureApnsDestinations(ApnsServiceBuilder builder) {
        ParamUtils.checkDestination(this.getGatewayHost(), this.getGatewayPort(), "gateway");
        ParamUtils.checkDestination(this.getFeedbackHost(), this.getFeedbackPort(), "feedback");
        if (ObjectHelper.isNotEmpty((Object)this.getGatewayHost())) {
            builder.withGatewayDestination(this.getGatewayHost(), this.getGatewayPort());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getFeedbackHost())) {
            builder.withFeedbackDestination(this.getFeedbackHost(), this.getFeedbackPort());
        }
    }

    private void configureApnsDelegate(ApnsServiceBuilder builder) {
        if (this.apnsDelegate != null) {
            builder.withDelegate(this.apnsDelegate);
        }
    }

    private void configureConnectionStrategy(ApnsServiceBuilder builder) {
        if (this.getConnectionStrategy() == ConnectionStrategy.POOL) {
            AssertUtils.isTrue(this.poolSize >= 1, "Pool size needs to be greater than: 1");
            AssertUtils.isTrue(this.poolSize <= 30, "Pool size needs to be lower than: 30");
        }
        if (this.getConnectionStrategy() == null) {
            return;
        }
        switch (this.getConnectionStrategy()) {
            case QUEUE: {
                builder.asQueued();
                break;
            }
            case POOL: {
                builder.asPool(this.getPoolSize());
                break;
            }
        }
    }

    private void configureReconnectionPolicy(ApnsServiceBuilder builder) {
        if (this.getReconnectionPolicy() == null) {
            return;
        }
        switch (this.getReconnectionPolicy()) {
            case EVERY_HALF_HOUR: {
                builder.withReconnectPolicy(ReconnectPolicy.Provided.EVERY_HALF_HOUR);
                break;
            }
            case EVERY_NOTIFICATION: {
                builder.withReconnectPolicy(ReconnectPolicy.Provided.EVERY_NOTIFICATION);
                break;
            }
            default: {
                builder.withReconnectPolicy(ReconnectPolicy.Provided.NEVER);
            }
        }
    }
}

