/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.impl.health.ContextHealthCheck;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@Liveness
public class CamelMicroProfileContextCheck
implements HealthCheck,
CamelContextAware {
    @Inject
    private CamelContext camelContext;
    private ContextHealthCheck contextHealthCheck = new ContextHealthCheck();

    public CamelMicroProfileContextCheck() {
        this.contextHealthCheck.getConfiguration().setEnabled(Boolean.valueOf(true));
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name("camel");
        builder.down();
        if (this.camelContext != null) {
            this.contextHealthCheck.setCamelContext(this.camelContext);
            HealthCheck.Result result = this.contextHealthCheck.call();
            Map details = result.getDetails();
            builder.withData("name", details.get("context.name").toString());
            builder.withData("contextStatus", details.get("context.status").toString());
            if (result.getState().equals((Object)HealthCheck.State.UP)) {
                builder.up();
            }
        }
        return builder.build();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

