/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceEndpoint;
import org.apache.camel.component.azure.queue.QueueServiceOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="azure-queue")
public class QueueServiceComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private QueueServiceConfiguration configuration;

    public QueueServiceComponent() {
    }

    public QueueServiceComponent(CamelContext context) {
        super(context);
        this.configuration = new QueueServiceConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        QueueServiceConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        String[] parts = null;
        if (remaining != null) {
            parts = remaining.split("/");
        }
        if (parts == null || parts.length < 1) {
            throw new IllegalArgumentException("The account name must be specified.");
        }
        QueueServiceOperations operation = configuration.getOperation();
        if (operation != null && operation != QueueServiceOperations.listQueues && parts.length < 2) {
            throw new IllegalArgumentException("The queue name must be specified.");
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only the account and queue names must be specified.");
        }
        configuration.setAccountName(parts[0]);
        if (parts.length > 1) {
            configuration.setQueueName(parts[1]);
        }
        this.checkAndSetRegistryClient(configuration);
        this.checkCredentials(configuration);
        QueueServiceEndpoint endpoint = new QueueServiceEndpoint(uri, (Component)this, configuration);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public QueueServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkCredentials(QueueServiceConfiguration cfg) {
        StorageCredentials creds;
        CloudQueue client = cfg.getAzureQueueClient();
        StorageCredentials storageCredentials = creds = client == null ? cfg.getCredentials() : client.getServiceClient().getCredentials();
        if (creds == null) {
            throw new IllegalArgumentException("Credentials must be specified.");
        }
    }

    private void checkAndSetRegistryClient(QueueServiceConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(CloudQueue.class);
        if (clients.size() == 1) {
            configuration.setAzureQueueClient((CloudQueue)clients.stream().findFirst().get());
        }
    }
}

