/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class BlobServiceEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return BlobServiceEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return BlobServiceEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "azureBlobClient": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setAzureBlobClient((CloudBlob)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, CloudBlob.class, (Object)value));
                return true;
            }
            case "blobType": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobType((BlobType)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobType.class, (Object)value)));
                return true;
            }
            case "operation": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setOperation((BlobServiceOperations)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobServiceOperations.class, (Object)value)));
                return true;
            }
            case "streamWriteSize": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setStreamWriteSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamReadSize": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setStreamReadSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blobMetadata": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobMetadata((Map)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "closeStreamAfterRead": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCloseStreamAfterRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closeStreamAfterWrite": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCloseStreamAfterWrite((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "fileDir": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setFileDir((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobOffset": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobOffset((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "dataLength": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setDataLength((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "blobPrefix": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobPrefix((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publicForRead": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setPublicForRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useFlatListing": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setUseFlatListing((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCredentials((StorageCredentials)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((BlobServiceEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((BlobServiceEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((BlobServiceEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((BlobServiceEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((BlobServiceEndpoint)((Object)endpoint)).setSynchronous((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((BlobServiceEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "azureblobclient": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setAzureBlobClient((CloudBlob)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, CloudBlob.class, (Object)value));
                return true;
            }
            case "blobtype": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobType((BlobType)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobType.class, (Object)value)));
                return true;
            }
            case "operation": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setOperation((BlobServiceOperations)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobServiceOperations.class, (Object)value)));
                return true;
            }
            case "streamwritesize": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setStreamWriteSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamreadsize": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setStreamReadSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blobmetadata": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobMetadata((Map)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "closestreamafterread": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCloseStreamAfterRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterwrite": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCloseStreamAfterWrite((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "filedir": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setFileDir((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bloboffset": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobOffset((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "datalength": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setDataLength((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "blobprefix": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setBlobPrefix((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publicforread": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setPublicForRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useflatlisting": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setUseFlatListing((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                ((BlobServiceEndpoint)((Object)endpoint)).getConfiguration().setCredentials((StorageCredentials)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((BlobServiceEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((BlobServiceEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((BlobServiceEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((BlobServiceEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((BlobServiceEndpoint)((Object)endpoint)).setSynchronous((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((BlobServiceEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

