/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.component.azure.blob.BlobServiceUtil;
import org.apache.camel.support.ScheduledPollConsumer;

public class BlobServiceConsumer
extends ScheduledPollConsumer {
    public BlobServiceConsumer(BlobServiceEndpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        Exchange exchange = super.getEndpoint().createExchange();
        try {
            this.log.trace("Getting the blob content");
            this.getBlob(exchange);
            super.getAsyncProcessor().process(exchange);
            return 1;
        }
        catch (StorageException ex) {
            if (404 == ex.getHttpStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    private void getBlob(Exchange exchange) throws Exception {
        BlobServiceUtil.getBlob(exchange, this.getConfiguration());
    }

    protected BlobServiceConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public BlobServiceEndpoint getEndpoint() {
        return (BlobServiceEndpoint)super.getEndpoint();
    }
}

