/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.component.cm.CMConfiguration;
import org.apache.camel.component.cm.CMEndpoint;
import org.apache.camel.component.cm.CMMessage;
import org.apache.camel.component.cm.CMSender;
import org.apache.camel.component.cm.client.SMSMessage;
import org.apache.camel.component.cm.exceptions.HostUnavailableException;
import org.apache.camel.support.DefaultProducer;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class CMProducer
extends DefaultProducer {
    private Validator validator;
    private CMSender sender;

    public CMProducer(CMEndpoint endpoint, CMSender sender) {
        super((Endpoint)endpoint);
        this.sender = sender;
    }

    public void process(Exchange exchange) throws Exception {
        SMSMessage smsMessage = (SMSMessage)exchange.getIn().getMandatoryBody(SMSMessage.class);
        this.log.trace("Validating SMSMessage instance provided: {}", (Object)smsMessage);
        Set constraintViolations = this.getValidator().validate((Object)smsMessage, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (ConstraintViolation cv : constraintViolations) {
                msg.append(String.format("- Invalid value for %s: %s", cv.getPropertyPath().toString(), cv.getMessage()));
            }
            this.log.debug(msg.toString());
            throw new InvalidPayloadRuntimeException(exchange, SMSMessage.class);
        }
        this.log.trace("SMSMessage instance is valid: {}", (Object)smsMessage);
        CMMessage cmMessage = new CMMessage(smsMessage.getPhoneNumber(), smsMessage.getMessage());
        this.log.debug("CMMessage instance build from valid SMSMessage instance");
        if (smsMessage.getFrom() == null || smsMessage.getFrom().isEmpty()) {
            String df = this.getConfiguration().getDefaultFrom();
            cmMessage.setSender(df);
            this.log.debug("Dynamic sender is set to default dynamic sender: {}", (Object)df);
        }
        cmMessage.setIdAsString(smsMessage.getId());
        cmMessage.setUnicodeAndMultipart(this.getConfiguration().getDefaultMaxNumberOfParts());
        this.sender.send(cmMessage);
        this.log.debug("Request accepted by CM Host: {}", (Object)cmMessage);
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting CMProducer");
        CMConfiguration configuration = this.getConfiguration();
        if (configuration.isTestConnectionOnStartup()) {
            try {
                this.log.debug("Checking connection - {}", (Object)this.getEndpoint().getCMUrl());
                HttpClientBuilder.create().build().execute((HttpUriRequest)new HttpHead(this.getEndpoint().getCMUrl()));
                this.log.debug("Connection to {}: OK", (Object)this.getEndpoint().getCMUrl());
            }
            catch (Exception e) {
                throw new HostUnavailableException(String.format("Connection to %s: NOT AVAILABLE", this.getEndpoint().getCMUrl()), e);
            }
        }
        super.doStart();
        this.log.debug("CMProducer started");
    }

    public CMEndpoint getEndpoint() {
        return (CMEndpoint)super.getEndpoint();
    }

    public CMConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.validator = this.getEndpoint().getComponent().getValidator();
        }
        return this.validator;
    }

    public CMSender getSender() {
        return this.sender;
    }

    public void setSender(CMSender sender) {
        this.sender = sender;
    }
}

