/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.engine.DefaultProducerCache;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientListProcessor
extends MulticastProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientListProcessor.class);
    private final Iterator<?> iter;
    private boolean ignoreInvalidEndpoints;
    private ProducerCache producerCache;

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<?> iter) {
        super(camelContext, null);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<?> iter, AggregationStrategy aggregationStrategy) {
        super(camelContext, null, aggregationStrategy);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<?> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate) {
        this(camelContext, producerCache, iter, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate, false);
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<?> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate, boolean stopOnAggregateException) {
        super(camelContext, null, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate, stopOnAggregateException);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        int index = 0;
        while (this.iter.hasNext()) {
            AsyncProducer producer;
            ExchangePattern pattern;
            Endpoint endpoint;
            Object recipient = this.iter.next();
            try {
                endpoint = RecipientListProcessor.resolveEndpoint(exchange, recipient);
                pattern = this.resolveExchangePattern(recipient);
                producer = this.producerCache.acquireProducer(endpoint);
            }
            catch (Exception e) {
                if (this.isIgnoreInvalidEndpoints()) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            result.add(this.createProcessorExchangePair(index++, endpoint, (Producer)producer, exchange, pattern));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Endpoint endpoint, Producer producer, Exchange exchange, ExchangePattern pattern) {
        Producer prepared = producer;
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        if (this.isShareUnitOfWork()) {
            this.prepareSharedUnitOfWork(copy, exchange);
        }
        RecipientListProcessor.setToEndpoint(copy, (Processor)prepared);
        RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
        prepared = this.createErrorHandler(routeContext, copy, (Processor)prepared);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(copy);
            }
            catch (Exception e) {
                copy.setException((Throwable)e);
            }
        }
        return new RecipientProcessorExchangePair(index, this.producerCache, endpoint, producer, (Processor)prepared, copy, pattern);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected ExchangePattern resolveExchangePattern(Object recipient) throws UnsupportedEncodingException, URISyntaxException, MalformedURLException {
        if (recipient instanceof String) {
            String s = ((String)recipient).trim();
            s = URISupport.normalizeUri((String)s);
            return EndpointHelper.resolveExchangePatternFromUrl((String)s);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerCache == null) {
            this.producerCache = new DefaultProducerCache((Object)this, this.getCamelContext(), 0);
        }
        ServiceHelper.startService((Object)this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.producerCache);
        super.doShutdown();
    }

    @Override
    public String toString() {
        return "RecipientList";
    }

    @Override
    public String getTraceLabel() {
        return "recipientList";
    }

    static final class RecipientProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Endpoint endpoint;
        private final AsyncProducer producer;
        private Processor prepared;
        private final Exchange exchange;
        private final ProducerCache producerCache;
        private final ExchangePattern pattern;
        private volatile ExchangePattern originalPattern;

        private RecipientProcessorExchangePair(int index, ProducerCache producerCache, Endpoint endpoint, Producer producer, Processor prepared, Exchange exchange, ExchangePattern pattern) {
            this.index = index;
            this.producerCache = producerCache;
            this.endpoint = endpoint;
            this.producer = AsyncProcessorConverterHelper.convert((Producer)producer);
            this.prepared = prepared;
            this.exchange = exchange;
            this.pattern = pattern;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            return this.producer;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
            LOG.trace("RecipientProcessorExchangePair #{} begin: {}", (Object)this.index, (Object)this.exchange);
            this.exchange.setProperty("CamelRecipientListEndpoint", (Object)this.endpoint.getEndpointUri());
            MessageHelper.resetStreamCache((Message)this.exchange.getIn());
            if (this.pattern != null) {
                this.originalPattern = this.exchange.getPattern();
                LOG.trace("Using exchangePattern: {} on exchange: {}", (Object)this.pattern, (Object)this.exchange);
                this.exchange.setPattern(this.pattern);
            }
        }

        @Override
        public void done() {
            block3: {
                LOG.trace("RecipientProcessorExchangePair #{} done: {}", (Object)this.index, (Object)this.exchange);
                try {
                    if (this.originalPattern != null) {
                        this.exchange.setPattern(this.originalPattern);
                    }
                    this.producerCache.releaseProducer(this.endpoint, this.producer);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Error releasing producer: " + this.producer + ". This exception will be ignored.", (Throwable)e);
                }
            }
        }
    }
}

