/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.consul;

import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.cloud.CamelSpringCloudServiceRegistryAutoConfiguration;
import org.apache.camel.spring.cloud.consul.ServiceDefinitionToConsulRegistration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
@AutoConfigureBefore(value={CamelSpringCloudServiceRegistryAutoConfiguration.class})
@ConditionalOnConsulEnabled
@Conditional(value={Condition.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
public class ServiceDefinitionToConsulRegistrationAutoConfiguration {
    @Bean(name={"service-definition-to-consul-registration"})
    public Converter<ServiceDefinition, ConsulRegistration> serviceDefinitionToConsulRegistration(CamelCloudConfigurationProperties properties) {
        return new ServiceDefinitionToConsulRegistration(properties);
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud", "camel.cloud.consul");
        }
    }
}

