/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.crypt;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.cms.common.AttributesGeneratorProvider;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerConfiguration;
import org.apache.camel.component.crypto.cms.common.OriginatorInformationProvider;
import org.apache.camel.component.crypto.cms.crypt.RecipientInfo;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class EnvelopedDataEncryptorConfiguration
extends CryptoCmsMarshallerConfiguration {
    private static final String CAST5_CBC_PKCS5_PADDING = "CAST5/CBC/PKCS5Padding";
    private static final String RC2_CBC_PKCS5_PADDING = "RC2/CBC/PKCS5Padding";
    private static final String CAMELLIA_CBC_PKCS5_PADDING = "Camellia/CBC/PKCS5Padding";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private static final String DES_CBC_PKCS5_PADDING = "DES/CBC/PKCS5Padding";
    private static final String DESEDE_CBC_PKCS5_PADDING = "DESede/CBC/PKCS5Padding";
    private static final Logger LOG = LoggerFactory.getLogger(EnvelopedDataEncryptorConfiguration.class);
    private static final Map<String, List<Integer>> SUPPORTED_ENCRYPTION_ALGORITHMS = new HashMap<String, List<Integer>>(7);
    @UriParam(label="encrypt", multiValue=true, description="Recipient Info: reference to a bean which implements the interface org.apache.camel.component.crypto.cms.api.TransRecipientInfo")
    private final List<RecipientInfo> recipient = new ArrayList<RecipientInfo>(3);
    @UriParam(label="encrypt", enums="AES/CBC/PKCS5Padding,DESede/CBC/PKCS5Padding,Camellia/CBC/PKCS5Padding,CAST5/CBC/PKCS5Padding")
    private String contentEncryptionAlgorithm;
    @UriParam(label="encrypt")
    private int secretKeyLength;
    @UriParam(label="encrypt", defaultValue="null")
    private AttributesGeneratorProvider unprotectedAttributesGeneratorProvider;
    @UriParam(label="encrypt", defaultValue="null")
    private OriginatorInformationProvider originatorInformationProvider;
    private ASN1ObjectIdentifier algorithmId;

    public EnvelopedDataEncryptorConfiguration(CamelContext context) {
        super(context);
    }

    private static boolean isLimitedEncryptionStrength() {
        boolean limitedEncryptionStrength;
        try {
            limitedEncryptionStrength = Cipher.getMaxAllowedKeyLength("AES") < 256;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return limitedEncryptionStrength;
    }

    public List<RecipientInfo> getRecipient() {
        return this.recipient;
    }

    public void setRecipient(RecipientInfo recipient) {
        this.recipient.add(recipient);
    }

    public void setRecipient(List<?> recipients) {
        if (recipients == null) {
            return;
        }
        for (Object recipientOb : recipients) {
            RecipientInfo recipient;
            if (!(recipientOb instanceof String)) continue;
            String recipientName = (String)recipientOb;
            String valueNoHash = recipientName.replaceAll("#", "");
            if (this.getContext() == null || recipientName == null || (recipient = (RecipientInfo)this.getContext().getRegistry().lookupByNameAndType(valueNoHash, RecipientInfo.class)) == null) continue;
            this.setRecipient(recipient);
        }
    }

    public String getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public void setContentEncryptionAlgorithm(String contentEncryptionAlgorithm) {
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public void setSecretKeyLength(int secretKeyLength) {
        this.secretKeyLength = secretKeyLength;
    }

    public AttributesGeneratorProvider getUnprotectedAttributesGeneratorProvider() {
        return this.unprotectedAttributesGeneratorProvider;
    }

    public void setUnprotectedAttributesGeneratorProvider(AttributesGeneratorProvider unprotectedAttributeTableGeneratorProvider) {
        this.unprotectedAttributesGeneratorProvider = unprotectedAttributeTableGeneratorProvider;
    }

    public OriginatorInformationProvider getOriginatorInformationProvider() {
        return this.originatorInformationProvider;
    }

    public void setOriginatorInformationProvider(OriginatorInformationProvider originatorInformationProvider) {
        this.originatorInformationProvider = originatorInformationProvider;
    }

    public void init() throws CryptoCmsException {
        if (this.recipient.size() == 0) {
            this.logErrorAndThrow(LOG, "No recipient configured.");
        }
        this.checkEncryptionAlgorithmAndSecretKeyLength();
        this.calcualteAlgorithmIdWithKeyLength();
    }

    private void checkEncryptionAlgorithmAndSecretKeyLength() throws CryptoCmsException {
        if (this.contentEncryptionAlgorithm == null) {
            this.logErrorAndThrow(LOG, "Content encryption algorithm is null");
        } else if (!SUPPORTED_ENCRYPTION_ALGORITHMS.keySet().contains(this.contentEncryptionAlgorithm)) {
            this.logErrorAndThrow(LOG, "Content encryption algorithm " + this.contentEncryptionAlgorithm + " not supported");
        } else if (!SUPPORTED_ENCRYPTION_ALGORITHMS.get(this.contentEncryptionAlgorithm).contains(this.secretKeyLength)) {
            this.logErrorAndThrow(LOG, "Content encryption algorithm " + this.contentEncryptionAlgorithm + " does not supported secretKeyLength of " + this.secretKeyLength);
        }
    }

    private void calcualteAlgorithmIdWithKeyLength() {
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            if (!DESEDE_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) break block14;
                            this.algorithmId = CMSAlgorithm.DES_EDE3_CBC;
                            break block15;
                        }
                        if (!DES_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) break block16;
                        this.algorithmId = CMSAlgorithm.DES_CBC;
                        break block15;
                    }
                    if (!AES_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) break block17;
                    switch (this.getSecretKeyLength()) {
                        case 256: {
                            this.algorithmId = CMSAlgorithm.AES256_CBC;
                            break block15;
                        }
                        case 192: {
                            this.algorithmId = CMSAlgorithm.AES192_CBC;
                            break block15;
                        }
                        case 128: {
                            this.algorithmId = CMSAlgorithm.AES128_CBC;
                            break block15;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported secret key length " + this.getSecretKeyLength() + " for algorithm AES");
                        }
                    }
                }
                if (!CAMELLIA_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) break block18;
                switch (this.getSecretKeyLength()) {
                    case 256: {
                        this.algorithmId = CMSAlgorithm.CAMELLIA256_CBC;
                        break block15;
                    }
                    case 192: {
                        this.algorithmId = CMSAlgorithm.CAMELLIA192_CBC;
                        break block15;
                    }
                    case 128: {
                        this.algorithmId = CMSAlgorithm.CAMELLIA128_CBC;
                        break block15;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported secret key length " + this.getSecretKeyLength() + " for algorithm Camellia");
                    }
                }
            }
            if (RC2_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) {
                this.algorithmId = CMSAlgorithm.RC2_CBC;
            } else if (CAST5_CBC_PKCS5_PADDING.equals(this.getContentEncryptionAlgorithm())) {
                this.algorithmId = CMSAlgorithm.CAST5_CBC;
            } else {
                throw new IllegalStateException("Content encryption algorithm " + this.getContentEncryptionAlgorithm() + " not supported");
            }
        }
    }

    public ASN1ObjectIdentifier getAlgorithmID() {
        return this.algorithmId;
    }

    static {
        List<Integer> allowedKeyLengthForAESandCamellia = EnvelopedDataEncryptorConfiguration.isLimitedEncryptionStrength() ? Arrays.asList(128) : Arrays.asList(256, 192, 128);
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(DESEDE_CBC_PKCS5_PADDING, Arrays.asList(192, 128));
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(DES_CBC_PKCS5_PADDING, Arrays.asList(64, 56));
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(AES_CBC_PKCS5_PADDING, allowedKeyLengthForAESandCamellia);
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(CAMELLIA_CBC_PKCS5_PADDING, allowedKeyLengthForAESandCamellia);
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(RC2_CBC_PKCS5_PADDING, Arrays.asList(128, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40));
        SUPPORTED_ENCRYPTION_ALGORITHMS.put(CAST5_CBC_PKCS5_PADDING, Arrays.asList(128, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40));
    }
}

