/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.crypt;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.CryptoCmsUnmarshaller;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataDecryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.PrivateKeyWithCertificate;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsFormatException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsNoCertificateForRecipientsException;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.OriginatorInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvelopedDataDecryptor
extends CryptoCmsUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(EnvelopedDataDecryptor.class);
    private final EnvelopedDataDecryptorConfiguration conf;

    public EnvelopedDataDecryptor(EnvelopedDataDecryptorConfiguration conf) {
        super(conf);
        this.conf = conf;
    }

    @Override
    protected Object unmarshalInternal(InputStream is, Exchange exchange) throws Exception {
        CMSEnvelopedDataParser parser;
        try {
            parser = new CMSEnvelopedDataParser(is);
        }
        catch (CMSException e) {
            throw new CryptoCmsFormatException(this.getFormatErrorMessage(), e);
        }
        catch (NullPointerException e) {
            throw new CryptoCmsFormatException(this.getFormatErrorMessage(), e);
        }
        return this.unmarshal(parser, exchange);
    }

    String getFormatErrorMessage() {
        return "Message has invalid format. It was not possible to parse the message into a PKCS7/CMS enveloped data object.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshal(CMSEnvelopedDataParser parser, Exchange exchange) throws Exception {
        AttributeTable unprotectedAttsTable;
        Object result;
        InputStream inputStream;
        LOG.debug("Decrypting CMS Enveloped Data started");
        this.debugLog(parser);
        RecipientInformationStore recipientsStore = parser.getRecipientInfos();
        if (recipientsStore.size() == 0) {
            throw new CryptoCmsException("PKCS7/CMS enveloped data message is incorrect. No recipient information found in enveloped data.");
        }
        RecipientInformation recipientInformation = null;
        Collection<PrivateKeyWithCertificate> privateKeyCerts = this.conf.getPrivateKeyCertificateCollection(exchange);
        if (privateKeyCerts.isEmpty()) {
            throw new CryptoCmsNoCertificateForRecipientsException("Cannot decrypt PKCS7/CMS enveloped data object. No private key for the decryption configured.");
        }
        PrivateKey foundPrivateKey = null;
        for (PrivateKeyWithCertificate privateKeyWithCertificate : privateKeyCerts) {
            X509Certificate cert = privateKeyWithCertificate.getCertificate();
            JceKeyTransRecipientId recipientId = new JceKeyTransRecipientId(cert);
            recipientInformation = recipientsStore.get((RecipientId)recipientId);
            if (recipientInformation == null) continue;
            LOG.debug("Recipient found for certificate with subjectDN={}, issuerDN={}, and serial number={}", new Object[]{cert.getSubjectDN(), cert.getIssuerDN(), cert.getSerialNumber()});
            foundPrivateKey = privateKeyWithCertificate.getPrivateKey();
            break;
        }
        if (recipientInformation == null) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(privateKeyCerts.size());
            for (PrivateKeyWithCertificate pc : privateKeyCerts) {
                certs.add(pc.getCertificate());
            }
            throw new CryptoCmsNoCertificateForRecipientsException("Cannot decrypt PKCS7/CMS enveloped data object. No certificate found among the configured certificates which fit to one of the recipients in the enveloped data object. The recipients in the enveloped data object are: " + this.recipientsToString(recipientsStore.getRecipients()) + "The configured certificates are: " + this.certsToString(certs) + ". Specify a certificate with private key which fits to one of the recipients in the configruation or check whether the encrypted message is encrypted with the correct key.");
        }
        JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(foundPrivateKey);
        try {
            inputStream = recipientInformation.getContentStream((Recipient)recipient).getContentStream();
        }
        catch (IOException | CMSException e) {
            throw new CryptoCmsException("Error during decrypting an enveloped data object", e);
        }
        try {
            result = this.transformToStreamCacheOrByteArray(exchange, inputStream);
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
        if (LOG.isDebugEnabled() && (unprotectedAttsTable = parser.getUnprotectedAttributes()) != null) {
            LOG.debug("Unprotected attributes size {}", (Object)unprotectedAttsTable.size());
            Hashtable unprotectedAtts = unprotectedAttsTable.toHashtable();
            if (unprotectedAtts != null) {
                LOG.debug("Unprotected attributes: {}", (Object)this.attributesToString(unprotectedAtts));
            }
        }
        return result;
    }

    protected void debugLog(CMSEnvelopedDataParser parser) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        OriginatorInformation originatorInfo = parser.getOriginatorInfo();
        if (originatorInfo != null) {
            Store crlsStore;
            Collection crls;
            LOG.debug("Enveloped Data has originator information");
            Store certStore = originatorInfo.getCertificates();
            Collection certs = certStore.getMatches(null);
            if (certs != null && certs.size() > 0) {
                LOG.debug("Certificates in the originator information:");
                for (X509CertificateHolder cert : certs) {
                    LOG.debug("    subject=" + cert.getSubject() + ", issuer=" + cert.getIssuer() + ", serial number=" + cert.getSerialNumber());
                }
            }
            if ((crls = (crlsStore = originatorInfo.getCRLs()).getMatches(null)) != null && crls.size() > 0) {
                LOG.debug("CRLs in the originator information:");
                for (X509CRLHolder crl : crls) {
                    LOG.debug("    CRL issuer={}", (Object)crl.getIssuer());
                    Collection revokedCerts = crl.getRevokedCertificates();
                    for (X509CRLEntryHolder revokedCert : revokedCerts) {
                        LOG.debug("        Revoked Certificate: issuer=" + revokedCert.getCertificateIssuer() + ", serial number=" + revokedCert.getSerialNumber() + ", date=" + revokedCert.getRevocationDate());
                    }
                }
            }
        }
        LOG.debug("Content encryption algorithm OID: {}", (Object)parser.getEncryptionAlgOID());
        LOG.debug("Recipient Infos:");
        RecipientInformationStore recipientStore = parser.getRecipientInfos();
        Collection recipients = recipientStore.getRecipients();
        int counter = 0;
        for (RecipientInformation recipient : recipients) {
            LOG.debug("   Recipient Info {}: {}", (Object)(++counter), (Object)this.recipientToString(recipient));
        }
    }

    protected String recipientsToString(Collection<RecipientInformation> recipients) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int size = recipients.size();
        for (RecipientInformation recipient : recipients) {
            ++counter;
            sb.append('[');
            sb.append(this.recipientToString(recipient));
            sb.append(']');
            if (counter >= size) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    protected String recipientToString(RecipientInformation recipient) {
        if (recipient instanceof KeyTransRecipientInformation) {
            KeyTransRecipientId rid = (KeyTransRecipientId)recipient.getRID();
            return "Issuer=" + rid.getIssuer() + ", serial number=" + rid.getSerialNumber() + ", key encryption algorithm OID=" + recipient.getKeyEncryptionAlgOID();
        }
        return "not a KeyTransRecipientInformation: " + recipient.getRID().getType();
    }

    protected String attributesToString(Hashtable<String, Attribute> attributes) {
        if (attributes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int size = attributes.size();
        int counter = 0;
        for (Attribute attr : attributes.values()) {
            sb.append(attr.getAttrType());
            if (++counter >= size) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transformToStreamCacheOrByteArray(Exchange exchange, InputStream is) throws CryptoCmsException {
        OutputStreamBuilder output = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            if (is != null) {
                try {
                    IOHelper.copy((InputStream)is, (OutputStream)output);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
            }
            LOG.debug("CMS Enveloped Data decryption successful");
            Object object = output.build();
            return object;
        }
        catch (IOException e) {
            throw new CryptoCmsException("Error during reading the unencrypted content of the enveloped data object", e);
        }
        finally {
            IOHelper.close((Closeable)output);
        }
    }
}

