/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms;

import java.security.KeyStore;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.crypto.cms.CryptoCmsEndpoint;
import org.apache.camel.component.crypto.cms.common.AttributesGeneratorProvider;
import org.apache.camel.component.crypto.cms.common.OriginatorInformationProvider;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;

public class CryptoCmsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return CryptoCmsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return CryptoCmsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "includeContent": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setIncludeContent((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "signer": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setSigner((String)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "toBase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setToBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "signedDataHeaderBase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setSignedDataHeaderBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "verifySignaturesOfAllSigners": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setVerifySignaturesOfAllSigners((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "fromBase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setFromBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyStoreParameters": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setKeyStoreParameters((KeyStoreParameters)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, KeyStoreParameters.class, (Object)value));
                return true;
            }
            case "keyStore": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setKeyStore((KeyStore)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "recipient": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setRecipient((List)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "contentEncryptionAlgorithm": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setContentEncryptionAlgorithm((String)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKeyLength": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setSecretKeyLength((Integer)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "unprotectedAttributesGeneratorProvider": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setUnprotectedAttributesGeneratorProvider((AttributesGeneratorProvider)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, AttributesGeneratorProvider.class, (Object)value));
                return true;
            }
            case "originatorInformationProvider": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setOriginatorInformationProvider((OriginatorInformationProvider)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, OriginatorInformationProvider.class, (Object)value));
                return true;
            }
            case "password": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getDecryptConfig().setPassword((char[])CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, char[].class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setSynchronous((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "includecontent": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setIncludeContent((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "signer": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setSigner((String)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tobase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getSignConfig().setToBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "signeddataheaderbase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setSignedDataHeaderBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "verifysignaturesofallsigners": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setVerifySignaturesOfAllSigners((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "frombase64": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setFromBase64((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keystoreparameters": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setKeyStoreParameters((KeyStoreParameters)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, KeyStoreParameters.class, (Object)value));
                return true;
            }
            case "keystore": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getVerifyConfig().setKeyStore((KeyStore)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "recipient": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setRecipient((List)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "contentencryptionalgorithm": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setContentEncryptionAlgorithm((String)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkeylength": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setSecretKeyLength((Integer)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "unprotectedattributesgeneratorprovider": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setUnprotectedAttributesGeneratorProvider((AttributesGeneratorProvider)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, AttributesGeneratorProvider.class, (Object)value));
                return true;
            }
            case "originatorinformationprovider": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getEncryptConfig().setOriginatorInformationProvider((OriginatorInformationProvider)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, OriginatorInformationProvider.class, (Object)value));
                return true;
            }
            case "password": {
                ((CryptoCmsEndpoint)((Object)endpoint)).getDecryptConfig().setPassword((char[])CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, char[].class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setSynchronous((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((CryptoCmsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)CryptoCmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

