/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.camel.component.gora.GoraEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.hadoop.conf.Configuration;

@Component(value="gora")
public class GoraComponent
extends DefaultComponent {
    private DataStore<Object, Persistent> dataStore;
    private Properties goraProperties;
    private Configuration configuration;

    private void init(GoraConfiguration config) throws IOException {
        this.goraProperties = DataStoreFactory.createProps();
        this.dataStore = DataStoreFactory.getDataStore((String)this.goraProperties.getProperty("gora.datastore.default", config.getDataStoreClass()), (String)config.getKeyClass(), (String)config.getValueClass(), (Configuration)this.configuration);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GoraConfiguration config = new GoraConfiguration();
        this.setProperties(config, parameters);
        config.setName(remaining);
        this.init(config);
        return new GoraEndpoint(uri, this, config, this.dataStore);
    }

    public DataStore<Object, Persistent> getDataStore() {
        return this.dataStore;
    }

    protected void doStart() throws Exception {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
    }

    protected void doStop() throws Exception {
        if (this.dataStore != null) {
            this.dataStore.close();
        }
    }
}

