/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="telegram")
public class TelegramComponent
extends DefaultComponent {
    @Metadata(label="security", secret=true)
    private String authorizationToken;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TelegramConfiguration configuration = new TelegramConfiguration();
        if (remaining.endsWith("/")) {
            remaining = remaining.substring(0, remaining.length() - 1);
        }
        configuration.setType(remaining);
        this.setProperties(configuration, parameters);
        if (configuration.getAuthorizationToken() == null) {
            configuration.setAuthorizationToken(this.authorizationToken);
        }
        if (configuration.getAuthorizationToken() == null) {
            throw new IllegalArgumentException("AuthorizationToken must be configured on either component or endpoint for telegram: " + uri);
        }
        if ("bots".equals(configuration.getType())) {
            return new TelegramEndpoint(uri, (Component)this, configuration);
        }
        throw new IllegalArgumentException("Unsupported endpoint type for uri " + uri + ", remaining " + remaining);
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }
}

