/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.websocket.jsr356.JSR356Consumer;
import org.apache.camel.websocket.jsr356.JSR356Producer;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

@UriEndpoint(firstVersion="2.23.0", scheme="websocket-jsr356", title="Javax Websocket", syntax="websocket-jsr356:websocketPathOrUri", label="jsr356")
public class JSR356Endpoint
extends DefaultEndpoint {
    @UriPath(description="If a path (/foo) it will deploy locally the endpoint, if an uri it will connect to the corresponding server")
    private String websocketPathOrUri;
    @UriParam(description="Used when the endpoint is in client mode to populate a pool of sessions")
    private int sessionCount = 1;
    private final JSR356WebSocketComponent component;

    public JSR356Endpoint(JSR356WebSocketComponent component, String uri) {
        super(uri, (Component)component);
        this.component = component;
    }

    public JSR356WebSocketComponent getComponent() {
        return (JSR356WebSocketComponent)((Object)JSR356WebSocketComponent.class.cast(super.getComponent()));
    }

    public Consumer createConsumer(Processor processor) {
        return new JSR356Consumer(this, processor, this.sessionCount);
    }

    public Producer createProducer() {
        return new JSR356Producer(this, this.sessionCount);
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }
}

