/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.lucene.LuceneEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.lucene.analysis.Analyzer;

public class LuceneEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return LuceneEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return LuceneEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "srcDir": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setSrcDir((File)LuceneEndpointConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "indexDir": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setIndexDir((File)LuceneEndpointConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "analyzer": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setAnalyzer((Analyzer)LuceneEndpointConfigurer.property((CamelContext)camelContext, Analyzer.class, (Object)value));
                return true;
            }
            case "maxHits": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setMaxHits((Integer)LuceneEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((LuceneEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((LuceneEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((LuceneEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)LuceneEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((LuceneEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)LuceneEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((LuceneEndpoint)((Object)endpoint)).setSynchronous((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((LuceneEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "srcdir": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setSrcDir((File)LuceneEndpointConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "indexdir": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setIndexDir((File)LuceneEndpointConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "analyzer": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setAnalyzer((Analyzer)LuceneEndpointConfigurer.property((CamelContext)camelContext, Analyzer.class, (Object)value));
                return true;
            }
            case "maxhits": {
                ((LuceneEndpoint)((Object)endpoint)).getConfig().setMaxHits((Integer)LuceneEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((LuceneEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((LuceneEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((LuceneEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)LuceneEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((LuceneEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)LuceneEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((LuceneEndpoint)((Object)endpoint)).setSynchronous((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((LuceneEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)LuceneEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

