/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentAutoConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentConfiguration;
import org.apache.camel.support.IntrospectionSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfigureAfter(value={ReactiveStreamsComponentAutoConfiguration.class})
@ConditionalOnBean(value={ReactiveStreamsComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ReactiveStreamsComponentConfiguration.class})
public class ReactiveStreamsServiceAutoConfiguration {
    @Autowired
    private CamelContext context;
    @Autowired
    private ReactiveStreamsComponentConfiguration configuration;

    @Lazy
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={CamelContext.class})
    public CamelReactiveStreamsService camelReactiveStreamsService() throws Exception {
        ReactiveStreamsEngineConfiguration engineConfiguration = new ReactiveStreamsEngineConfiguration();
        if (this.configuration.getInternalEngineConfiguration() != null) {
            HashMap parameters = new HashMap();
            IntrospectionSupport.getProperties((Object)this.configuration.getInternalEngineConfiguration(), parameters, null, (boolean)false);
            IntrospectionSupport.setProperties((CamelContext)this.context, (TypeConverter)this.context.getTypeConverter(), (Object)engineConfiguration, parameters);
        }
        return ReactiveStreamsHelper.resolveReactiveStreamsService((CamelContext)this.context, (String)this.configuration.getServiceType(), (ReactiveStreamsEngineConfiguration)engineConfiguration);
    }
}

