/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AvroEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return AvroEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return AvroEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "protocolLocation": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocolLocation((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocol": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocol((Protocol)AvroEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "protocolClassName": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocolClassName((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uriAuthority": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setUriAuthority((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "reflectionProtocol": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setReflectionProtocol((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "singleParameter": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setSingleParameter((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((AvroEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((AvroEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((AvroEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)AvroEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((AvroEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)AvroEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((AvroEndpoint)((Object)endpoint)).setSynchronous((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((AvroEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "protocollocation": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocolLocation((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocol": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocol((Protocol)AvroEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "protocolclassname": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setProtocolClassName((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uriauthority": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setUriAuthority((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "reflectionprotocol": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setReflectionProtocol((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "singleparameter": {
                ((AvroEndpoint)((Object)endpoint)).getConfiguration().setSingleParameter((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((AvroEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((AvroEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((AvroEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)AvroEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((AvroEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)AvroEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((AvroEndpoint)((Object)endpoint)).setSynchronous((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((AvroEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

