/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.aws.firehose.KinesisFirehoseEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class KinesisFirehoseEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return KinesisFirehoseEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return KinesisFirehoseEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "accessKey": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonKinesisFirehoseClient": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setAmazonKinesisFirehoseClient((AmazonKinesisFirehose)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, AmazonKinesisFirehose.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setSynchronous((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "accesskey": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisfirehoseclient": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setAmazonKinesisFirehoseClient((AmazonKinesisFirehose)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, AmazonKinesisFirehose.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setSynchronous((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((KinesisFirehoseEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KinesisFirehoseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

