/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.camel.test.cdi.FrameworkAnnotatedParameter;

final class FrameworkMethodInjectionPoint
implements InjectionPoint {
    private final Method method;
    private final FrameworkAnnotatedParameter annotated;
    private final Type type;
    private final Set<Annotation> qualifiers;

    FrameworkMethodInjectionPoint(Method method, int position, BeanManager manager) {
        this.method = method;
        this.annotated = new FrameworkAnnotatedParameter(method, position, manager);
        this.type = method.getGenericParameterTypes()[position];
        this.qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : method.getParameterAnnotations()[position]) {
            if (!manager.isQualifier(annotation.annotationType())) continue;
            this.qualifiers.add(annotation);
        }
    }

    public Bean<?> getBean() {
        return null;
    }

    public Member getMember() {
        return this.method;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDelegate() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }
}

