/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.policy;

import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.component.jcache.policy.JCachePolicyProcessor;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCachePolicy
implements Policy {
    private static final Logger LOG = LoggerFactory.getLogger(JCachePolicy.class);
    private Cache cache;
    private CacheManager cacheManager;
    private String cacheName;
    private Configuration cacheConfiguration;
    private Expression keyExpression;
    private boolean enabled = true;

    public void beforeWrap(RouteContext routeContext, NamedNode namedNode) {
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        if (!this.isEnabled()) {
            return processor;
        }
        Cache cache = this.cache;
        if (cache == null) {
            Set lookupResult;
            CacheManager cacheManager = this.cacheManager;
            if (cacheManager == null && ObjectHelper.isNotEmpty((Object)(lookupResult = routeContext.getCamelContext().getRegistry().findByType(CacheManager.class)))) {
                cacheManager = (CacheManager)lookupResult.iterator().next();
                LOG.debug("CacheManager from CamelContext registry: {}", (Object)cacheManager);
            }
            if (cacheManager == null) {
                cacheManager = Caching.getCachingProvider().getCacheManager();
                LOG.debug("CacheManager from CachingProvider: {}", (Object)cacheManager);
            }
            String cacheName = ObjectHelper.isNotEmpty((Object)this.cacheName) ? this.cacheName : routeContext.getRouteId();
            LOG.debug("Getting cache:{}", (Object)cacheName);
            cache = cacheManager.getCache(cacheName);
            if (cache == null) {
                LOG.debug("Create cache:{}", (Object)cacheName);
                cache = cacheManager.createCache(cacheName, (Configuration)(this.cacheConfiguration != null ? this.cacheConfiguration : new MutableConfiguration()));
            }
        }
        return new JCachePolicyProcessor(cache, this.keyExpression, processor);
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "JCachePolicy{keyExpression=" + this.keyExpression + ", enabled=" + this.enabled + '}';
    }
}

