/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.listeners;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.jbpm.JBPMCamelConsumerAware;
import org.apache.camel.component.jbpm.JBPMConsumer;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.internal.runtime.Cacheable;

public class CamelProcessEventListener
implements ProcessEventListener,
Cacheable,
JBPMCamelConsumerAware {
    private Set<JBPMConsumer> consumers = new LinkedHashSet<JBPMConsumer>();

    public void beforeProcessStarted(ProcessStartedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeProcessStarted", event);
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterProcessStarted", event);
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeProcessCompleted", event);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterProcessCompleted", event);
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeNodeTriggered", event);
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterNodeTriggered", event);
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeNodeLeft", event);
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterNodeLeft", event);
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeVariableChanged", event);
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterVariableChanged", event);
    }

    public void close() {
    }

    @Override
    public void addConsumer(JBPMConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(JBPMConsumer consumer) {
        this.consumers.remove((Object)consumer);
    }

    protected void sendMessage(String eventType, Object event) {
        this.consumers.stream().filter(c -> c.getStatus().isStarted()).forEach(c -> c.sendMessage(eventType, event));
    }
}

