/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.ddbstream.DdbStreamEndpoint;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DdbStreamEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return DdbStreamEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return DdbStreamEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "accessKey": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonDynamoDbStreamsClient": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, AmazonDynamoDBStreams.class, (Object)value));
                return true;
            }
            case "maxResultsPerRequest": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setMaxResultsPerRequest((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "iteratorType": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setIteratorType((ShardIteratorType)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "sequenceNumberProvider": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setSequenceNumberProvider((SequenceNumberProvider)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, SequenceNumberProvider.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setStartScheduler((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setInitialDelay((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setDelay((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((DdbStreamEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((DdbStreamEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((DdbStreamEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((DdbStreamEndpoint)((Object)endpoint)).setGreedy((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setScheduler((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSchedulerProperties((Map)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((DdbStreamEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((DdbStreamEndpoint)((Object)endpoint)).setRepeatCount((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((DdbStreamEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((DdbStreamEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSynchronous((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "accesskey": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazondynamodbstreamsclient": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, AmazonDynamoDBStreams.class, (Object)value));
                return true;
            }
            case "maxresultsperrequest": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setMaxResultsPerRequest((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "iteratortype": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setIteratorType((ShardIteratorType)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "sequencenumberprovider": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setSequenceNumberProvider((SequenceNumberProvider)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, SequenceNumberProvider.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((DdbStreamEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setStartScheduler((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setInitialDelay((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setDelay((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((DdbStreamEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((DdbStreamEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((DdbStreamEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((DdbStreamEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((DdbStreamEndpoint)((Object)endpoint)).setGreedy((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setScheduler((String)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSchedulerProperties((Map)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((DdbStreamEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((DdbStreamEndpoint)((Object)endpoint)).setRepeatCount((Long)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((DdbStreamEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((DdbStreamEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((DdbStreamEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DdbStreamEndpoint)((Object)endpoint)).setSynchronous((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((DdbStreamEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DdbStreamEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

