/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.WatchedEventProvider;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public abstract class FutureEventDrivenOperation<ResultType>
extends ZooKeeperOperation<ResultType>
implements Watcher,
WatchedEventProvider {
    private Watcher.Event.EventType[] awaitedTypes;
    private CountDownLatch waitForAnyWatchedType = new CountDownLatch(1);
    private WatchedEvent event;

    public FutureEventDrivenOperation(ZooKeeper connection, String node, Watcher.Event.EventType ... awaitedTypes) {
        super(connection, node);
        this.awaitedTypes = awaitedTypes;
    }

    public void process(WatchedEvent event) {
        this.event = event;
        Watcher.Event.EventType received = event.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Recieved event of type %s for node '%s'", received, event.getPath()));
        }
        for (Watcher.Event.EventType watched : this.awaitedTypes) {
            if (!watched.equals((Object)received)) continue;
            this.result = this.getResult();
            this.waitForAnyWatchedType.countDown();
        }
        if (LOG.isTraceEnabled() && this.waitForAnyWatchedType.getCount() > 0L) {
            StringBuilder b = new StringBuilder();
            for (Watcher.Event.EventType type : this.awaitedTypes) {
                b.append(type).append(", ");
            }
            if (b.length() > 0) {
                b.setLength(b.length() - 2);
            }
            LOG.trace(String.format("Recieved event of type %s did not match any watched types %s", received, Arrays.toString(this.awaitedTypes)));
        }
    }

    @Override
    public OperationResult<ResultType> get() throws InterruptedException, ExecutionException {
        this.installWatch();
        this.waitingThreads.add(Thread.currentThread());
        this.waitForAnyWatchedType.await();
        return this.result;
    }

    @Override
    public OperationResult<ResultType> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.installWatch();
        this.waitingThreads.add(Thread.currentThread());
        this.waitForAnyWatchedType.await(timeout, unit);
        return this.result;
    }

    protected abstract void installWatch();

    @Override
    public WatchedEvent getWatchedEvent() {
        return this.event;
    }

    public Watcher.Event.EventType[] getWatchedForTypes() {
        return this.awaitedTypes;
    }
}

