/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.dataformat.protobuf.ProtobufConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.io.IOUtils;

@Dataformat(value="protobuf")
public class ProtobufDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    public static final String CONTENT_TYPE_FORMAT_NATIVE = "native";
    public static final String CONTENT_TYPE_FORMAT_JSON = "json";
    private static final String CONTENT_TYPE_HEADER_NATIVE = "application/octet-stream";
    private static final String CONTENT_TYPE_HEADER_JSON = "application/json";
    private CamelContext camelContext;
    private Message defaultInstance;
    private String instanceClassName;
    private boolean contentTypeHeader;
    private String contentTypeFormat = "native";

    public ProtobufDataFormat() {
    }

    public ProtobufDataFormat(Message defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public ProtobufDataFormat(Message defaultInstance, String contentTypeFormat) {
        this.defaultInstance = defaultInstance;
        this.contentTypeFormat = contentTypeFormat;
    }

    public String getDataFormatName() {
        return "protobuf";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setDefaultInstance(Message instance) {
        this.defaultInstance = instance;
    }

    public void setDefaultInstance(Object instance) {
        if (!(instance instanceof Message)) {
            throw new IllegalArgumentException("The argument for setDefaultInstance should be subClass of com.google.protobuf.Message");
        }
        this.defaultInstance = (Message)instance;
    }

    public void setInstanceClass(String className) throws Exception {
        ObjectHelper.notNull((Object)className, (String)"ProtobufDataFormat instaceClass");
        this.instanceClassName = className;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeFormat(String contentTypeFormat) {
        StringHelper.notEmpty((String)contentTypeFormat, (String)"ProtobufDataFormat contentTypeFormat");
        this.contentTypeFormat = contentTypeFormat;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        Message inputMessage = this.convertGraphToMessage(exchange, graph);
        String contentTypeHeader = CONTENT_TYPE_HEADER_NATIVE;
        if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_JSON)) {
            IOUtils.write((String)JsonFormat.printer().print((MessageOrBuilder)inputMessage), (OutputStream)outputStream, (String)"UTF-8");
            contentTypeHeader = CONTENT_TYPE_HEADER_JSON;
        } else if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_NATIVE)) {
            inputMessage.writeTo(outputStream);
        } else {
            throw new CamelException("Invalid protobuf content type format: " + this.contentTypeFormat);
        }
        if (this.isContentTypeHeader()) {
            if (exchange.getMessage() != null) {
                exchange.getMessage().setHeader("Content-Type", (Object)contentTypeHeader);
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)contentTypeHeader);
            }
        }
    }

    private Message convertGraphToMessage(Exchange exchange, Object inputData) throws NoTypeConversionAvailableException {
        Map messageInMap = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, exchange, inputData);
        if (messageInMap != null) {
            ProtobufConverter protobufConverter = ProtobufConverter.create(this.defaultInstance);
            return protobufConverter.toProto(messageInMap);
        }
        return (Message)exchange.getContext().getTypeConverter().mandatoryConvertTo(Message.class, exchange, inputData);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        ObjectHelper.notNull((Object)this.defaultInstance, (String)"defaultInstance or instanceClassName must be set", (Object)((Object)this));
        Message.Builder builder = this.defaultInstance.newBuilderForType();
        if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_JSON)) {
            JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(inputStream), builder);
        } else if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_NATIVE)) {
            builder = this.defaultInstance.newBuilderForType().mergeFrom(inputStream);
        } else {
            throw new CamelException("Invalid protobuf content type format: " + this.contentTypeFormat);
        }
        if (!builder.isInitialized()) {
            throw new InvalidPayloadException(exchange, this.defaultInstance.getClass());
        }
        return builder.build();
    }

    protected Message loadDefaultInstance(String className, CamelContext context) throws CamelException, ClassNotFoundException {
        Class instanceClass = context.getClassResolver().resolveMandatoryClass(className);
        if (Message.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("getDefaultInstance", new Class[0]);
                return (Message)method.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new CamelException("Can't set the defaultInstance of ProtobufferDataFormat with " + className + ", caused by " + ex);
            }
        }
        throw new CamelException("Can't set the defaultInstance of ProtobufferDataFormat with " + className + ", as the class is not a subClass of com.google.protobuf.Message");
    }

    protected void doStart() throws Exception {
        if (this.defaultInstance == null && this.instanceClassName != null) {
            this.defaultInstance = this.loadDefaultInstance(this.instanceClassName, this.getCamelContext());
        }
    }

    protected void doStop() throws Exception {
    }
}

