/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jira.JiraComponent;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.JiraType;
import org.apache.camel.component.jira.consumer.NewCommentsConsumer;
import org.apache.camel.component.jira.consumer.NewIssuesConsumer;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.apache.camel.component.jira.producer.AddCommentProducer;
import org.apache.camel.component.jira.producer.AddIssueProducer;
import org.apache.camel.component.jira.producer.AttachFileProducer;
import org.apache.camel.component.jira.producer.DeleteIssueProducer;
import org.apache.camel.component.jira.producer.TransitionIssueProducer;
import org.apache.camel.component.jira.producer.UpdateIssueProducer;
import org.apache.camel.component.jira.producer.WatcherProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0", scheme="jira", title="Jira", syntax="jira:type", label="api,reporting")
public class JiraEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(JiraEndpoint.class);
    @UriPath
    @Metadata(required=true)
    private JiraType type;
    @UriParam(label="consumer")
    private String jql;
    @UriParam(label="consumer", defaultValue="50")
    private Integer maxResults = 50;
    @UriParam
    private JiraConfiguration configuration;
    private JiraRestClient client;

    public JiraEndpoint(String uri, JiraComponent component, JiraConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public JiraConfiguration getConfiguration() {
        return this.configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        Registry registry = this.getCamelContext().getRegistry();
        Object factory = (JiraRestClientFactory)registry.lookupByNameAndType("JiraRestClientFactory", JiraRestClientFactory.class);
        if (factory == null) {
            factory = new OAuthAsynchronousJiraRestClientFactory();
        }
        URI jiraServerUri = URI.create(this.configuration.getJiraUrl());
        if (this.configuration.getUsername() != null) {
            LOG.info("Jira Basic authentication with username/password.");
            this.client = factory.createWithBasicHttpAuthentication(jiraServerUri, this.configuration.getUsername(), this.configuration.getPassword());
        } else {
            LOG.info("Jira OAuth authentication.");
            JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler(this.configuration.getConsumerKey(), this.configuration.getVerificationCode(), this.configuration.getPrivateKey(), this.configuration.getAccessToken(), this.configuration.getJiraUrl());
            this.client = factory.create(jiraServerUri, (AuthenticationHandler)oAuthHandler);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.close();
        }
    }

    public Producer createProducer() {
        switch (this.type) {
            case ADDISSUE: {
                return new AddIssueProducer(this);
            }
            case ATTACH: {
                return new AttachFileProducer(this);
            }
            case ADDCOMMENT: {
                return new AddCommentProducer(this);
            }
            case WATCHERS: {
                return new WatcherProducer(this);
            }
            case DELETEISSUE: {
                return new DeleteIssueProducer(this);
            }
            case UPDATEISSUE: {
                return new UpdateIssueProducer(this);
            }
            case TRANSITIONISSUE: {
                return new TransitionIssueProducer(this);
            }
        }
        throw new IllegalArgumentException("Producer does not support type: " + (Object)((Object)this.type));
    }

    public Consumer createConsumer(Processor processor) {
        if (this.type == JiraType.NEWCOMMENTS) {
            return new NewCommentsConsumer(this, processor);
        }
        if (this.type == JiraType.NEWISSUES) {
            return new NewIssuesConsumer(this, processor);
        }
        throw new IllegalArgumentException("Consumer does not support type: " + (Object)((Object)this.type));
    }

    public boolean isSingleton() {
        return true;
    }

    public JiraType getType() {
        return this.type;
    }

    public void setType(JiraType type) {
        this.type = type;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public int getDelay() {
        return this.configuration.getDelay();
    }

    public JiraRestClient getClient() {
        return this.client;
    }

    public void setClient(JiraRestClient client) {
        this.client = client;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }
}

