/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mybatis.BaseMyBatisEndpoint;
import org.apache.camel.component.mybatis.MyBatisBeanProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.22.0", scheme="mybatis-bean", title="MyBatis Bean", syntax="mybatis-bean:beanName:methodName", producerOnly=true, label="database,sql")
public class MyBatisBeanEndpoint
extends BaseMyBatisEndpoint {
    @UriPath
    @Metadata(required=true)
    private String beanName;
    @UriPath
    @Metadata(required=true)
    private String methodName;

    public MyBatisBeanEndpoint() {
    }

    public MyBatisBeanEndpoint(String endpointUri, Component component, String beanName, String methodName) {
        super(endpointUri, component);
        this.beanName = beanName;
        this.methodName = methodName;
    }

    public Producer createProducer() throws Exception {
        return new MyBatisBeanProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("Consumer not support on this component (mybatis-bean), use mybatis instead.");
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
}

