/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.math.BigInteger;
import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The web3j component uses the Web3j client API and allows you to add/read
 * nodes to/from a web3j compliant content repositories.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Web3jEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Web3j Ethereum Blockchain
     * component.
     */
    public interface Web3jEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWeb3jEndpointConsumerBuilder advanced() {
            return (AdvancedWeb3jEndpointConsumerBuilder) this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder addresses(List<String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder fromBlock(Object fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder fullTransactionObjects(
                boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder fullTransactionObjects(
                String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder gasLimit(BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder privateFor(List<String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder toBlock(Object toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder topics(List<String> topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder web3j(Object web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointConsumerBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Web3jEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Web3jEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Web3j Ethereum Blockchain
     * component.
     */
    public interface AdvancedWeb3jEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Web3jEndpointConsumerBuilder basic() {
            return (Web3jEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeb3jEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeb3jEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeb3jEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeb3jEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Web3j Ethereum Blockchain
     * component.
     */
    public interface Web3jEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWeb3jEndpointProducerBuilder advanced() {
            return (AdvancedWeb3jEndpointProducerBuilder) this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder addresses(List<String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder fromBlock(Object fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder fullTransactionObjects(
                boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder fullTransactionObjects(
                String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder gasLimit(BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder privateFor(List<String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder toBlock(Object toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder topics(List<String> topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder web3j(Object web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointProducerBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * Contract address.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder address(String address) {
            doSetProperty("address", address);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder atBlock(Object atBlock) {
            doSetProperty("atBlock", atBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder atBlock(String atBlock) {
            doSetProperty("atBlock", atBlock);
            return this;
        }
        /**
         * Hash of the block where this transaction was in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder blockHash(String blockHash) {
            doSetProperty("blockHash", blockHash);
            return this;
        }
        /**
         * A random hexadecimal(32 bytes) ID identifying the client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The compiled code of a contract OR the hash of the invoked method
         * signature and encoded parameters.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder data(String data) {
            doSetProperty("data", data);
            return this;
        }
        /**
         * The local database name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder databaseName(String databaseName) {
            doSetProperty("databaseName", databaseName);
            return this;
        }
        /**
         * The filter id to use.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder filterId(BigInteger filterId) {
            doSetProperty("filterId", filterId);
            return this;
        }
        /**
         * The filter id to use.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder filterId(String filterId) {
            doSetProperty("filterId", filterId);
            return this;
        }
        /**
         * Gas price used for each paid gas.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder gasPrice(BigInteger gasPrice) {
            doSetProperty("gasPrice", gasPrice);
            return this;
        }
        /**
         * Gas price used for each paid gas.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder gasPrice(String gasPrice) {
            doSetProperty("gasPrice", gasPrice);
            return this;
        }
        /**
         * A hexadecimal string representation (32 bytes) of the hash rate.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder hashrate(String hashrate) {
            doSetProperty("hashrate", hashrate);
            return this;
        }
        /**
         * The header's pow-hash (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder headerPowHash(String headerPowHash) {
            doSetProperty("headerPowHash", headerPowHash);
            return this;
        }
        /**
         * The transactions/uncle index position in the block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder index(BigInteger index) {
            doSetProperty("index", index);
            return this;
        }
        /**
         * The transactions/uncle index position in the block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder index(String index) {
            doSetProperty("index", index);
            return this;
        }
        /**
         * The key name in the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder keyName(String keyName) {
            doSetProperty("keyName", keyName);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The mix digest (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder mixDigest(String mixDigest) {
            doSetProperty("mixDigest", mixDigest);
            return this;
        }
        /**
         * The nonce found (64 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder nonce(String nonce) {
            doSetProperty("nonce", nonce);
            return this;
        }
        /**
         * Operation to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The transaction index position withing a block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder position(BigInteger position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * The transaction index position withing a block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder position(String position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * The priority of a whisper message.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder priority(BigInteger priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * The priority of a whisper message.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder priority(String priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Message to sign by calculating an Ethereum specific signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder sha3HashOfDataToSign(
                String sha3HashOfDataToSign) {
            doSetProperty("sha3HashOfDataToSign", sha3HashOfDataToSign);
            return this;
        }
        /**
         * The signed transaction data for a new message call transaction or a
         * contract creation for signed transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder signedTransactionData(
                String signedTransactionData) {
            doSetProperty("signedTransactionData", signedTransactionData);
            return this;
        }
        /**
         * The source code to compile.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder sourceCode(String sourceCode) {
            doSetProperty("sourceCode", sourceCode);
            return this;
        }
        /**
         * The information about a transaction requested by transaction hash.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder transactionHash(
                String transactionHash) {
            doSetProperty("transactionHash", transactionHash);
            return this;
        }
        /**
         * The time to live in seconds of a whisper message.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder ttl(BigInteger ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The time to live in seconds of a whisper message.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The value sent within a transaction.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder value(BigInteger value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * The value sent within a transaction.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         */
        default Web3jEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Web3j Ethereum Blockchain
     * component.
     */
    public interface AdvancedWeb3jEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Web3jEndpointProducerBuilder basic() {
            return (Web3jEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Web3j Ethereum Blockchain component.
     */
    public interface Web3jEndpointBuilder
            extends
                Web3jEndpointConsumerBuilder, Web3jEndpointProducerBuilder {
        default AdvancedWeb3jEndpointBuilder advanced() {
            return (AdvancedWeb3jEndpointBuilder) this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder addresses(List<String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder fromBlock(Object fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder fullTransactionObjects(
                boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder fullTransactionObjects(
                String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder gasLimit(BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder privateFor(List<String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a:
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder toBlock(Object toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.core.DefaultBlockParameter</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder topics(List<String> topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder web3j(Object web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         */
        default Web3jEndpointBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Web3j Ethereum Blockchain
     * component.
     */
    public interface AdvancedWeb3jEndpointBuilder
            extends
                AdvancedWeb3jEndpointConsumerBuilder, AdvancedWeb3jEndpointProducerBuilder {
        default Web3jEndpointBuilder basic() {
            return (Web3jEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeb3jEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * The web3j component uses the Web3j client API and allows you to add/read
     * nodes to/from a web3j compliant content repositories.
     * 
     * Category: bitcoin,blockchain
     * Available as of version: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     * 
     * Syntax: <code>web3j:nodeAddress</code>
     * 
     * Path parameter: nodeAddress (required)
     * Sets the node address used to communicate
     */
    default Web3jEndpointBuilder web3j(String path) {
        class Web3jEndpointBuilderImpl extends AbstractEndpointBuilder implements Web3jEndpointBuilder, AdvancedWeb3jEndpointBuilder {
            public Web3jEndpointBuilderImpl(String path) {
                super("web3j", path);
            }
        }
        return new Web3jEndpointBuilderImpl(path);
    }
}