/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The aws-swf component is used for managing workflows from Amazon Simple
 * Workflow.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SWFEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AWS Simple Workflow component.
     */
    public interface SWFEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSWFEndpointConsumerBuilder advanced() {
            return (AdvancedSWFEndpointConsumerBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointConsumerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SWFEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SWFEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The list name to consume activities from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityList(String activityList) {
            doSetProperty("activityList", activityList);
            return this;
        }
        /**
         * Maximum number of threads in work pool for activity.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityThreadPoolSize(
                int activityThreadPoolSize) {
            doSetProperty("activityThreadPoolSize", activityThreadPoolSize);
            return this;
        }
        /**
         * Maximum number of threads in work pool for activity.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityThreadPoolSize(
                String activityThreadPoolSize) {
            doSetProperty("activityThreadPoolSize", activityThreadPoolSize);
            return this;
        }
        /**
         * Activity execution options.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityTypeExecutionOptions(
                Object activityTypeExecutionOptions) {
            doSetProperty("activityTypeExecutionOptions", activityTypeExecutionOptions);
            return this;
        }
        /**
         * Activity execution options.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityTypeExecutionOptions(
                String activityTypeExecutionOptions) {
            doSetProperty("activityTypeExecutionOptions", activityTypeExecutionOptions);
            return this;
        }
        /**
         * Activity registration options.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityTypeRegistrationOptions(
                Object activityTypeRegistrationOptions) {
            doSetProperty("activityTypeRegistrationOptions", activityTypeRegistrationOptions);
            return this;
        }
        /**
         * Activity registration options.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointConsumerBuilder activityTypeRegistrationOptions(
                String activityTypeRegistrationOptions) {
            doSetProperty("activityTypeRegistrationOptions", activityTypeRegistrationOptions);
            return this;
        }
        /**
         * The list name to consume workflows from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointConsumerBuilder workflowList(String workflowList) {
            doSetProperty("workflowList", workflowList);
            return this;
        }
        /**
         * Workflow registration options.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointConsumerBuilder workflowTypeRegistrationOptions(
                Object workflowTypeRegistrationOptions) {
            doSetProperty("workflowTypeRegistrationOptions", workflowTypeRegistrationOptions);
            return this;
        }
        /**
         * Workflow registration options.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointConsumerBuilder workflowTypeRegistrationOptions(
                String workflowTypeRegistrationOptions) {
            doSetProperty("workflowTypeRegistrationOptions", workflowTypeRegistrationOptions);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS Simple Workflow
     * component.
     */
    public interface AdvancedSWFEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SWFEndpointConsumerBuilder basic() {
            return (SWFEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSWFEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSWFEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSWFEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSWFEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder clientConfigurationParameters(
                Map<String, Object> clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder clientConfigurationParameters(
                String clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder startWorkflowOptionsParameters(
                Map<String, Object> startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder startWorkflowOptionsParameters(
                String startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder sWClientParameters(
                Map<String, Object> sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder sWClientParameters(
                String sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS Simple Workflow component.
     */
    public interface SWFEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSWFEndpointProducerBuilder advanced() {
            return (AdvancedSWFEndpointProducerBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointProducerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SWFEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SWFEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Activity scheduling options.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointProducerBuilder activitySchedulingOptions(
                Object activitySchedulingOptions) {
            doSetProperty("activitySchedulingOptions", activitySchedulingOptions);
            return this;
        }
        /**
         * Activity scheduling options.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions</code> type.
         * 
         * Group: activity
         */
        default SWFEndpointProducerBuilder activitySchedulingOptions(
                String activitySchedulingOptions) {
            doSetProperty("activitySchedulingOptions", activitySchedulingOptions);
            return this;
        }
        /**
         * The policy to use on child workflows when terminating a workflow.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder childPolicy(String childPolicy) {
            doSetProperty("childPolicy", childPolicy);
            return this;
        }
        /**
         * Set the execution start to close timeout.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder executionStartToCloseTimeout(
                String executionStartToCloseTimeout) {
            doSetProperty("executionStartToCloseTimeout", executionStartToCloseTimeout);
            return this;
        }
        /**
         * Workflow operation.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The name of the signal to send to the workflow.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder signalName(String signalName) {
            doSetProperty("signalName", signalName);
            return this;
        }
        /**
         * The type of the result when a workflow state is queried.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder stateResultType(
                String stateResultType) {
            doSetProperty("stateResultType", stateResultType);
            return this;
        }
        /**
         * Set the task start to close timeout.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder taskStartToCloseTimeout(
                String taskStartToCloseTimeout) {
            doSetProperty("taskStartToCloseTimeout", taskStartToCloseTimeout);
            return this;
        }
        /**
         * Details for terminating a workflow.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder terminationDetails(
                String terminationDetails) {
            doSetProperty("terminationDetails", terminationDetails);
            return this;
        }
        /**
         * The reason for terminating a workflow.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: workflow
         */
        default SWFEndpointProducerBuilder terminationReason(
                String terminationReason) {
            doSetProperty("terminationReason", terminationReason);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS Simple Workflow
     * component.
     */
    public interface AdvancedSWFEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SWFEndpointProducerBuilder basic() {
            return (SWFEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder clientConfigurationParameters(
                Map<String, Object> clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder clientConfigurationParameters(
                String clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder startWorkflowOptionsParameters(
                Map<String, Object> startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder startWorkflowOptionsParameters(
                String startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder sWClientParameters(
                Map<String, Object> sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder sWClientParameters(
                String sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS Simple Workflow component.
     */
    public interface SWFEndpointBuilder
            extends
                SWFEndpointConsumerBuilder, SWFEndpointProducerBuilder {
        default AdvancedSWFEndpointBuilder advanced() {
            return (AdvancedSWFEndpointBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.simpleworkflow.flow.DataConverter</code>
         * type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SWFEndpointBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SWFEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Simple Workflow component.
     */
    public interface AdvancedSWFEndpointBuilder
            extends
                AdvancedSWFEndpointConsumerBuilder, AdvancedSWFEndpointProducerBuilder {
        default SWFEndpointBuilder basic() {
            return (SWFEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder clientConfigurationParameters(
                Map<String, Object> clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder clientConfigurationParameters(
                String clientConfigurationParameters) {
            doSetProperty("clientConfigurationParameters", clientConfigurationParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder startWorkflowOptionsParameters(
                Map<String, Object> startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder startWorkflowOptionsParameters(
                String startWorkflowOptionsParameters) {
            doSetProperty("startWorkflowOptionsParameters", startWorkflowOptionsParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder sWClientParameters(
                Map<String, Object> sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder sWClientParameters(
                String sWClientParameters) {
            doSetProperty("sWClientParameters", sWClientParameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSWFEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * AWS Simple Workflow (camel-aws-swf)
     * The aws-swf component is used for managing workflows from Amazon Simple
     * Workflow.
     * 
     * Category: cloud,workflow
     * Available as of version: 2.13
     * Maven coordinates: org.apache.camel:camel-aws-swf
     * 
     * Syntax: <code>aws-swf:type</code>
     * 
     * Path parameter: type (required)
     * Activity or workflow
     * The value can be one of: activity, workflow
     */
    default SWFEndpointBuilder awsSwf(String path) {
        class SWFEndpointBuilderImpl extends AbstractEndpointBuilder implements SWFEndpointBuilder, AdvancedSWFEndpointBuilder {
            public SWFEndpointBuilderImpl(String path) {
                super("aws-swf", path);
            }
        }
        return new SWFEndpointBuilderImpl(path);
    }
}