/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The google-calendar component provides access to Google Calendar in a
 * streaming mode.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GoogleCalendarStreamEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Google Calendar Stream component.
     */
    public interface GoogleCalendarStreamEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedGoogleCalendarStreamEndpointBuilder advanced() {
            return (AdvancedGoogleCalendarStreamEndpointBuilder) this;
        }
        /**
         * OAuth 2 access token. This typically expires after an hour so
         * refreshToken is recommended for long term usage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder accessToken(
                String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Google Calendar application name. Example would be
         * camel-google-calendar/1.0.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder applicationName(
                String applicationName) {
            doSetProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The calendarId to be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder calendarId(String calendarId) {
            doSetProperty("calendarId", calendarId);
            return this;
        }
        /**
         * Client ID of the calendar application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Client secret of the calendar application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder clientSecret(
                String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * Take into account the lastUpdate of the last event polled as start
         * date for the next poll.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder considerLastUpdate(
                boolean considerLastUpdate) {
            doSetProperty("considerLastUpdate", considerLastUpdate);
            return this;
        }
        /**
         * Take into account the lastUpdate of the last event polled as start
         * date for the next poll.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder considerLastUpdate(
                String considerLastUpdate) {
            doSetProperty("considerLastUpdate", considerLastUpdate);
            return this;
        }
        /**
         * Consume events in the selected calendar from now on.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder consumeFromNow(
                boolean consumeFromNow) {
            doSetProperty("consumeFromNow", consumeFromNow);
            return this;
        }
        /**
         * Consume events in the selected calendar from now on.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder consumeFromNow(
                String consumeFromNow) {
            doSetProperty("consumeFromNow", consumeFromNow);
            return this;
        }
        /**
         * Max results to be returned.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder maxResults(int maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * Max results to be returned.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * The query to execute on calendar.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * OAuth 2 refresh token. Using this, the Google Calendar component can
         * obtain a new accessToken whenever the current one expires - a
         * necessity if the application is long-lived.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder refreshToken(
                String refreshToken) {
            doSetProperty("refreshToken", refreshToken);
            return this;
        }
        /**
         * Specifies the level of permissions you want a calendar application to
         * have to a user account. See
         * https://developers.google.com/calendar/auth for more info.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder scopes(List<String> scopes) {
            doSetProperty("scopes", scopes);
            return this;
        }
        /**
         * Specifies the level of permissions you want a calendar application to
         * have to a user account. See
         * https://developers.google.com/calendar/auth for more info.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamEndpointBuilder scopes(String scopes) {
            doSetProperty("scopes", scopes);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Google Calendar Stream component.
     */
    public interface AdvancedGoogleCalendarStreamEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default GoogleCalendarStreamEndpointBuilder basic() {
            return (GoogleCalendarStreamEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGoogleCalendarStreamEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGoogleCalendarStreamEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGoogleCalendarStreamEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGoogleCalendarStreamEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * The google-calendar component provides access to Google Calendar in a
     * streaming mode.
     * 
     * Category: api,cloud
     * Available as of version: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * Syntax: <code>google-calendar-stream:index</code>
     * 
     * Path parameter: index
     * Specifies an index for the endpoint
     */
    default GoogleCalendarStreamEndpointBuilder googleCalendarStream(String path) {
        class GoogleCalendarStreamEndpointBuilderImpl extends AbstractEndpointBuilder implements GoogleCalendarStreamEndpointBuilder, AdvancedGoogleCalendarStreamEndpointBuilder {
            public GoogleCalendarStreamEndpointBuilderImpl(String path) {
                super("google-calendar-stream", path);
            }
        }
        return new GoogleCalendarStreamEndpointBuilderImpl(path);
    }
}