/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The dataset-test component extends the mock component by on startup to pull
 * messages from another endpoint to set the expected message bodies.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DataSetTestEndpointBuilderFactory {


    /**
     * Builder for endpoint for the DataSet Test component.
     */
    public interface DataSetTestEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDataSetTestEndpointBuilder advanced() {
            return (AdvancedDataSetTestEndpointBuilder) this;
        }
        /**
         * Whether the expected messages should arrive in the same order or can
         * be in any order.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder anyOrder(boolean anyOrder) {
            doSetProperty("anyOrder", anyOrder);
            return this;
        }
        /**
         * Whether the expected messages should arrive in the same order or can
         * be in any order.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder anyOrder(String anyOrder) {
            doSetProperty("anyOrder", anyOrder);
            return this;
        }
        /**
         * The split delimiter to use when split is enabled. By default the
         * delimiter is new line based. The delimiter can be a regular
         * expression.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * If enabled the messages loaded from the test endpoint will be split
         * using new line delimiters so each line is an expected message. For
         * example to use a file endpoint to load a file where each line is an
         * expected message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder split(boolean split) {
            doSetProperty("split", split);
            return this;
        }
        /**
         * If enabled the messages loaded from the test endpoint will be split
         * using new line delimiters so each line is an expected message. For
         * example to use a file endpoint to load a file where each line is an
         * expected message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder split(String split) {
            doSetProperty("split", split);
            return this;
        }
        /**
         * The timeout to use when polling for message bodies from the URI.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * The timeout to use when polling for message bodies from the URI.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default DataSetTestEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the DataSet Test component.
     */
    public interface AdvancedDataSetTestEndpointBuilder
            extends
                EndpointProducerBuilder {
        default DataSetTestEndpointBuilder basic() {
            return (DataSetTestEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDataSetTestEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDataSetTestEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDataSetTestEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDataSetTestEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * DataSet Test (camel-dataset)
     * The dataset-test component extends the mock component by on startup to
     * pull messages from another endpoint to set the expected message bodies.
     * 
     * Category: core,testing
     * Available as of version: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * Syntax: <code>dataset-test:name</code>
     * 
     * Path parameter: name (required)
     * Name of endpoint to lookup in the registry to use for polling messages
     * used for testing
     */
    default DataSetTestEndpointBuilder datasetTest(String path) {
        class DataSetTestEndpointBuilderImpl extends AbstractEndpointBuilder implements DataSetTestEndpointBuilder, AdvancedDataSetTestEndpointBuilder {
            public DataSetTestEndpointBuilderImpl(String path) {
                super("dataset-test", path);
            }
        }
        return new DataSetTestEndpointBuilderImpl(path);
    }
}