/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The class component is for invoking Java classes (Java beans) from Camel.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ClassEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Class component.
     */
    public interface ClassEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedClassEndpointBuilder advanced() {
            return (AdvancedClassEndpointBuilder) this;
        }
        /**
         * If enabled, Camel will cache the result of the first Registry
         * look-up. Cache can be enabled if the bean in the Registry is defined
         * as a singleton scope.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default ClassEndpointBuilder cache(Boolean cache) {
            doSetProperty("cache", cache);
            return this;
        }
        /**
         * If enabled, Camel will cache the result of the first Registry
         * look-up. Cache can be enabled if the bean in the Registry is defined
         * as a singleton scope.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default ClassEndpointBuilder cache(String cache) {
            doSetProperty("cache", cache);
            return this;
        }
        /**
         * Sets the name of the method to invoke on the bean.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ClassEndpointBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * Used for configuring additional properties on the bean.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default ClassEndpointBuilder parameters(Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Used for configuring additional properties on the bean.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default ClassEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Class component.
     */
    public interface AdvancedClassEndpointBuilder
            extends
                EndpointProducerBuilder {
        default ClassEndpointBuilder basic() {
            return (ClassEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClassEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClassEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClassEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClassEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Class (camel-bean)
     * The class component is for invoking Java classes (Java beans) from Camel.
     * 
     * Category: core,java
     * Available as of version: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * Syntax: <code>class:beanName</code>
     * 
     * Path parameter: beanName (required)
     * Sets the name of the bean to invoke
     */
    default ClassEndpointBuilder clas(String path) {
        class ClassEndpointBuilderImpl extends AbstractEndpointBuilder implements ClassEndpointBuilder, AdvancedClassEndpointBuilder {
            public ClassEndpointBuilderImpl(String path) {
                super("class", path);
            }
        }
        return new ClassEndpointBuilderImpl(path);
    }
}