/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import com.surftools.BeanstalkClient.Client;
import com.surftools.BeanstalkClientImpl.ClientImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;

public class ConnectionSettings {
    final String host;
    final int port;
    final String[] tubes;

    public ConnectionSettings(String tube) {
        this("localhost", 11300, tube);
    }

    public ConnectionSettings(String host, String tube) {
        this(host, 11300, tube);
    }

    public ConnectionSettings(String host, int port, String tube) {
        this.host = host;
        this.port = port;
        Scanner scanner = new Scanner(tube);
        scanner.useDelimiter("\\+");
        ArrayList<String> buffer = new ArrayList<String>();
        while (scanner.hasNext()) {
            String tubeRaw = scanner.next();
            try {
                buffer.add(URLDecoder.decode(tubeRaw, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                buffer.add(tubeRaw);
            }
        }
        this.tubes = buffer.toArray(new String[buffer.size()]);
        scanner.close();
    }

    public Client newWritingClient() throws IllegalArgumentException {
        if (this.tubes.length > 1) {
            throw new IllegalArgumentException("There must be only one tube specified for Beanstalk producer");
        }
        String tube = this.tubes.length > 0 ? this.tubes[0] : "default";
        ClientImpl client = new ClientImpl(this.host, this.port);
        client.useTube(tube);
        return client;
    }

    public Client newReadingClient(boolean useBlockIO) {
        ClientImpl client = new ClientImpl(this.host, this.port, useBlockIO);
        for (String tube : this.tubes) {
            client.watch(tube);
        }
        return client;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionSettings) {
            ConnectionSettings other = (ConnectionSettings)obj;
            return other.host.equals(this.host) && other.port == this.port && Arrays.equals(other.tubes, this.tubes);
        }
        return false;
    }

    public int hashCode() {
        return 41 * (41 * (41 + this.host.hashCode()) + this.port) + Arrays.hashCode(this.tubes);
    }

    public String toString() {
        return "beanstalk://" + this.host + ":" + this.port + "/" + Arrays.toString(this.tubes);
    }
}

