/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.services.kafka.AWSKafka;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.msk.MSKComponentVerifierExtension;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws-msk")
public class MSKComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private MSKConfiguration configuration = new MSKConfiguration();

    public MSKComponent() {
        this(null);
    }

    public MSKComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MSKComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSKConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon msk client or accessKey and secretKey must be specified");
        }
        MSKEndpoint endpoint = new MSKEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }

    public MSKConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSKConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }

    private void checkAndSetRegistryClient(MSKConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSKafka.class);
        if (clients.size() == 1) {
            configuration.setMskClient((AWSKafka)clients.stream().findFirst().get());
        }
    }
}

