/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.apache.camel.impl.engine.DefaultFactoryFinder;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OsgiFactoryFinder
extends DefaultFactoryFinder {
    private BundleContext bundleContext;

    public OsgiFactoryFinder(BundleContext bundleContext, ClassResolver classResolver, String resourcePath) {
        super(classResolver, resourcePath);
        this.bundleContext = bundleContext;
    }

    public Optional<Class<?>> findClass(String key, String propertyPrefix, Class<?> checkClass) {
        String prefix = propertyPrefix != null ? propertyPrefix : "";
        String classKey = propertyPrefix + key;
        Class answer = this.addToClassMap(classKey, () -> {
            BundleEntry entry = this.getResource(key, checkClass);
            if (entry != null) {
                URL url = entry.url;
                InputStream in = url.openStream();
                BufferedInputStream reader = null;
                try {
                    reader = IOHelper.buffered((InputStream)in);
                    Properties properties = new Properties();
                    properties.load(reader);
                    String className = properties.getProperty(prefix + "class");
                    if (className == null) {
                        throw new IOException("Expected property is missing: " + prefix + "class");
                    }
                    Class clazz = entry.bundle.loadClass(className);
                    return clazz;
                }
                finally {
                    IOHelper.close((Closeable)reader, (String)key, null);
                    IOHelper.close((Closeable)in, (String)key, null);
                }
            }
            return null;
        });
        return Optional.ofNullable(answer);
    }

    public Optional<Class<?>> findClass(String key, String propertyPrefix) {
        return this.findClass(key, propertyPrefix, null);
    }

    public BundleEntry getResource(String name) {
        return this.getResource(name, null);
    }

    public BundleEntry getResource(String name, Class<?> clazz) {
        Bundle[] bundles;
        BundleEntry entry = null;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            URL url = bundle.getEntry(this.getResourcePath() + name);
            if (url == null || !this.checkCompatibility(bundle, clazz)) continue;
            entry = new BundleEntry();
            entry.url = url;
            entry.bundle = bundle;
            break;
        }
        return entry;
    }

    private boolean checkCompatibility(Bundle bundle, Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        try {
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private static class BundleEntry {
        URL url;
        Bundle bundle;

        private BundleEntry() {
        }
    }
}

