/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.cluster;

import io.atomix.Atomix;
import io.atomix.group.DistributedGroup;
import io.atomix.group.GroupMember;
import io.atomix.group.LocalMember;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.atomix.AtomixConfiguration;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.util.ObjectHelper;

final class AtomixClusterView
extends AbstractCamelClusterView {
    private final Atomix atomix;
    private final AtomixLocalMember localMember;
    private final AtomixConfiguration<?> configuration;
    private DistributedGroup group;

    AtomixClusterView(CamelClusterService cluster, String namespace, Atomix atomix, AtomixConfiguration<?> configuration) {
        super(cluster, namespace);
        this.atomix = atomix;
        this.configuration = configuration;
        this.localMember = new AtomixLocalMember();
    }

    public Optional<CamelClusterMember> getLeader() {
        if (this.group == null) {
            return Optional.empty();
        }
        GroupMember leader = this.group.election().term().leader();
        if (leader == null) {
            return Optional.empty();
        }
        return Optional.of(new AtomixClusterMember(leader));
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        if (this.group == null) {
            return Collections.emptyList();
        }
        return this.group.members().stream().map(x$0 -> new AtomixClusterMember((GroupMember)x$0)).collect(Collectors.toList());
    }

    protected void doStart() throws Exception {
        if (!this.localMember.hasJoined()) {
            this.log.debug("Get group {}", (Object)this.getNamespace());
            this.group = (DistributedGroup)this.atomix.getGroup(this.getNamespace(), new DistributedGroup.Config(this.configuration.getResourceConfig(this.getNamespace())), new DistributedGroup.Options(this.configuration.getResourceOptions(this.getNamespace()))).get();
            this.log.debug("Listen election events");
            this.group.election().onElection(term -> {
                if (this.isRunAllowed()) {
                    this.fireLeadershipChangedEvent(Optional.of(this.toClusterMember(term.leader())));
                }
            });
            this.log.debug("Listen join events");
            this.group.onJoin(member -> {
                if (this.isRunAllowed()) {
                    this.fireMemberAddedEvent(this.toClusterMember((GroupMember)member));
                }
            });
            this.log.debug("Listen leave events");
            this.group.onLeave(member -> {
                if (this.isRunAllowed()) {
                    this.fireMemberRemovedEvent(this.toClusterMember((GroupMember)member));
                }
            });
            this.log.debug("Join group {}", (Object)this.getNamespace());
            this.localMember.join();
        }
    }

    protected void doStop() throws Exception {
        this.localMember.leave();
    }

    protected CamelClusterMember toClusterMember(GroupMember member) {
        return this.localMember != null && this.localMember.is(member) ? this.localMember : new AtomixClusterMember(member);
    }

    final class AtomixClusterMember
    implements CamelClusterMember {
        private final GroupMember member;

        AtomixClusterMember(GroupMember member) {
            this.member = member;
        }

        public String getId() {
            return this.member.id();
        }

        public boolean isLeader() {
            if (AtomixClusterView.this.group == null) {
                return false;
            }
            if (this.member == null) {
                return false;
            }
            return this.member.equals(AtomixClusterView.this.group.election().term().leader());
        }

        public boolean isLocal() {
            return AtomixClusterView.this.localMember != null ? AtomixClusterView.this.localMember.is(this.member) : false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AtomixClusterMember{");
            sb.append("group=").append(AtomixClusterView.this.group);
            sb.append(", member=").append(this.member);
            sb.append('}');
            return sb.toString();
        }
    }

    final class AtomixLocalMember
    implements CamelClusterMember {
        private LocalMember member;

        AtomixLocalMember() {
        }

        public String getId() {
            String id = AtomixClusterView.this.getClusterService().getId();
            if (ObjectHelper.isNotEmpty((Object)id)) {
                return id;
            }
            if (this.member == null) {
                throw new IllegalStateException("The view has not yet joined the cluster");
            }
            return this.member.id();
        }

        public boolean isLeader() {
            if (this.member == null) {
                return false;
            }
            return this.member.equals(AtomixClusterView.this.group.election().term().leader());
        }

        public boolean isLocal() {
            return true;
        }

        boolean is(GroupMember member) {
            return this.member != null ? this.member.equals(member) : false;
        }

        boolean hasJoined() {
            return this.member != null;
        }

        AtomixLocalMember join() throws ExecutionException, InterruptedException {
            if (this.member == null && AtomixClusterView.this.group != null) {
                String id = AtomixClusterView.this.getClusterService().getId();
                if (ObjectHelper.isEmpty((Object)id) || AtomixClusterView.this.configuration.isEphemeral()) {
                    AtomixClusterView.this.log.debug("Joining group: {}", (Object)AtomixClusterView.this.group);
                    this.member = (LocalMember)AtomixClusterView.this.group.join().join();
                    AtomixClusterView.this.log.debug("Group {} joined with id {}", (Object)AtomixClusterView.this.group, (Object)this.member.id());
                } else {
                    AtomixClusterView.this.log.debug("Joining group: {}, with id: {}", (Object)AtomixClusterView.this.group, (Object)id);
                    this.member = (LocalMember)AtomixClusterView.this.group.join(id).join();
                }
            }
            return this;
        }

        AtomixLocalMember leave() {
            if (this.member != null) {
                String id = this.member.id();
                AtomixClusterView.this.log.debug("Member {} : leave group {}", (Object)id, (Object)AtomixClusterView.this.group);
                this.member.leave().join();
                AtomixClusterView.this.group.remove(id).join();
                this.member = null;
                AtomixClusterView.this.fireLeadershipChangedEvent(Optional.empty());
            }
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AtomixLocalMember{");
            sb.append("member=").append(this.member);
            sb.append('}');
            return sb.toString();
        }
    }
}

