/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.netflix;

import java.util.List;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.cloud.CamelSpringCloudServiceLoadBalancer;
import org.apache.camel.spring.cloud.CamelSpringCloudServiceRegistryAutoConfiguration;
import org.apache.camel.spring.cloud.netflix.CamelCloudNetflixServiceLoadBalancer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;

@Configuration
@AutoConfigureAfter(value={RibbonAutoConfiguration.class})
@AutoConfigureBefore(value={CamelSpringCloudServiceRegistryAutoConfiguration.class})
@Conditional(value={Condition.class})
public class CamelCloudNetflixServiceLoadBalancerAutoConfiguration {
    @ConditionalOnBean(value={LoadBalancerClient.class})
    @ConditionalOnMissingBean
    @Bean(value={"netflix-client-load-balancer-adapter"})
    public CamelSpringCloudServiceLoadBalancer.LoadBalancerClientAdapter netflixClientLoadBalancerAdapter(List<ConversionService> conversionServices) {
        return client -> new CamelCloudNetflixServiceLoadBalancer(client, conversionServices);
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud", "camel.cloud.netflix");
        }
    }
}

