/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPDecoder
extends CumulativeProtocolDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPDecoder.class);
    private static final String DECODER_STATE = HL7MLLPDecoder.class.getName() + ".STATE";
    private static final String CHARSET_DECODER = HL7MLLPDecoder.class.getName() + ".charsetdecoder";
    private HL7MLLPConfig config;

    HL7MLLPDecoder(HL7MLLPConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecoderState state = this.decoderState(session);
        in.position(state.current());
        LOG.debug("Received data, checking from position {} to {}", (Object)in.position(), (Object)in.limit());
        boolean messageDecoded = false;
        while (in.hasRemaining()) {
            int previousPosition = in.position();
            byte current = in.get();
            if (current == this.config.getEndByte2() && state.previous() == this.config.getEndByte1()) {
                if (state.isStarted()) {
                    int currentPosition = in.position();
                    int currentLimit = in.limit();
                    LOG.debug("Message ends at position {} with length {}", (Object)previousPosition, (Object)(previousPosition - state.start() + 1));
                    in.position(state.start());
                    in.limit(currentPosition);
                    LOG.debug("Set start to position {} and limit to {}", (Object)in.position(), (Object)in.limit());
                    try {
                        out.write(this.config.isProduceString() ? this.parseMessageToString(in.slice(), this.charsetDecoder(session)) : this.parseMessageToByteArray(in.slice()));
                        messageDecoded = true;
                        continue;
                    }
                    finally {
                        LOG.debug("Resetting to position {} and limit to {}", (Object)currentPosition, (Object)currentLimit);
                        in.position(currentPosition);
                        in.limit(currentLimit);
                        state.reset();
                        continue;
                    }
                }
                LOG.warn("Ignoring message end at position {} until start byte has been seen.", (Object)previousPosition);
                continue;
            }
            if (current == this.config.getStartByte()) {
                state.markStart(previousPosition);
            } else {
                state.markPrevious(current);
            }
            messageDecoded = false;
        }
        if (!messageDecoded) {
            LOG.debug("No complete message yet at position {}", (Object)in.position());
            state.markCurrent(in.position());
            in.position(0);
        }
        return messageDecoded;
    }

    private Object parseMessageToByteArray(IoBuffer buf) throws CharacterCodingException {
        int len = buf.limit() - 3;
        LOG.debug("Making byte array of length {}", (Object)len);
        byte[] dst = new byte[len];
        buf.skip(1);
        buf.get(dst, 0, len);
        buf.skip(2);
        if (this.config.isConvertLFtoCR()) {
            LOG.debug("Replacing LF by CR");
            for (int i = 0; i < dst.length; ++i) {
                if (dst[i] != 10) continue;
                dst[i] = 13;
            }
        }
        return dst;
    }

    private Object parseMessageToString(IoBuffer buf, CharsetDecoder decoder) throws CharacterCodingException {
        int len = buf.limit() - 3;
        LOG.debug("Making string of length {} using charset {}", (Object)len, (Object)decoder.charset());
        buf.skip(1);
        String message = buf.getString(len, decoder);
        buf.skip(2);
        if (this.config.isConvertLFtoCR()) {
            LOG.debug("Replacing LF by CR");
            message = message.replace('\n', '\r');
        }
        return message;
    }

    public void dispose(IoSession session) throws Exception {
        session.removeAttribute((Object)DECODER_STATE);
        session.removeAttribute((Object)CHARSET_DECODER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharsetDecoder charsetDecoder(IoSession session) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            CharsetDecoder decoder = (CharsetDecoder)session.getAttribute((Object)CHARSET_DECODER);
            if (decoder == null) {
                decoder = this.config.getCharset().newDecoder().onMalformedInput(this.config.getMalformedInputErrorAction()).onUnmappableCharacter(this.config.getUnmappableCharacterErrorAction());
                session.setAttribute((Object)CHARSET_DECODER, (Object)decoder);
            }
            return decoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecoderState decoderState(IoSession session) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE);
            if (decoderState == null) {
                decoderState = new DecoderState();
                session.setAttribute((Object)DECODER_STATE, (Object)decoderState);
            }
            return decoderState;
        }
    }

    private static class DecoderState {
        private int startPos = -1;
        private int currentPos;
        private byte previousByte;

        private DecoderState() {
        }

        void reset() {
            this.startPos = -1;
            this.currentPos = 0;
            this.previousByte = 0;
        }

        void markStart(int position) {
            if (this.isStarted()) {
                LOG.warn("Ignoring message start at position {} before previous message has ended.", (Object)position);
            } else {
                this.startPos = position;
                LOG.debug("Message starts at position {}", (Object)this.startPos);
            }
        }

        void markCurrent(int position) {
            this.currentPos = position;
        }

        void markPrevious(byte previous) {
            this.previousByte = previous;
        }

        public int start() {
            return this.startPos;
        }

        public int current() {
            return this.currentPos;
        }

        public byte previous() {
            return this.previousByte;
        }

        public boolean isStarted() {
            return this.startPos >= 0;
        }
    }
}

