/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.springboot.customizer;

import com.hazelcast.core.HazelcastInstance;
import org.apache.camel.component.hazelcast.HazelcastDefaultComponent;
import org.apache.camel.component.hazelcast.springboot.customizer.AbstractHazelcastInstanceCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.ConfigurationCondition;

public abstract class AbstractHazelcastInstanceCustomizer<T extends HazelcastDefaultComponent, C extends AbstractHazelcastInstanceCustomizerConfiguration>
implements HasId,
ComponentCustomizer<T> {
    @Autowired
    private HazelcastInstance hazelcastInstance;
    @Autowired
    private C configuration;

    public void customize(T component) {
        if (((AbstractHazelcastInstanceCustomizerConfiguration)this.configuration).isOverride() || component.getHazelcastInstance() == null) {
            component.setHazelcastInstance(this.hazelcastInstance);
        }
    }

    public static class NestedConditions
    extends AllNestedConditions {
        public NestedConditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CamelAutoConfiguration.class})
        static class OnCamelAutoConfiguration {
            OnCamelAutoConfiguration() {
            }
        }

        @ConditionalOnBean(value={HazelcastInstance.class})
        static class OnHazelcastInstance {
            OnHazelcastInstance() {
            }
        }
    }
}

