/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.cmis.CMISEndpoint;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.component.cmis.CMISSessionFacadeFactory;
import org.apache.camel.component.cmis.CamelCMISActions;
import org.apache.camel.component.cmis.exception.CamelCmisException;
import org.apache.camel.component.cmis.exception.CamelCmisObjectNotFoundException;
import org.apache.camel.component.cmis.exception.CamelCmisUnauthorizedException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;

public class CMISProducer
extends DefaultProducer {
    private final CMISSessionFacadeFactory sessionFacadeFactory;
    private CMISSessionFacade sessionFacade;

    public CMISProducer(CMISEndpoint endpoint, CMISSessionFacadeFactory sessionFacadeFactory) {
        super((Endpoint)endpoint);
        this.sessionFacadeFactory = sessionFacadeFactory;
        this.sessionFacade = null;
    }

    public CMISEndpoint getEndpoint() {
        return (CMISEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        CamelCMISActions action = (CamelCMISActions)((Object)exchange.getIn().getHeader("cmis:action", CamelCMISActions.class));
        Class[] paramMethod = new Class[]{Exchange.class};
        Method method = ReflectionHelper.findMethod(((Object)((Object)this)).getClass(), (String)action.getMethodName(), (Class[])paramMethod);
        Object object = ObjectHelper.invokeMethod((Method)method, (Object)((Object)this), (Object[])new Object[]{exchange});
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody(object);
    }

    private Map<String, Object> filterTypeProperties(Map<String, Object> properties) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(properties.size());
        String objectTypeName = "cmis:document";
        if (properties.containsKey("cmis:objectTypeId")) {
            objectTypeName = (String)properties.get("cmis:objectTypeId");
        }
        HashSet<String> types = new HashSet<String>();
        types.addAll(this.getSessionFacade().getPropertiesFor(objectTypeName));
        if (this.getSessionFacade().supportsSecondaries() && properties.containsKey("cmis:secondaryObjectTypeIds")) {
            Collection secondaryTypes = (Collection)properties.get("cmis:secondaryObjectTypeIds");
            for (String secondaryType : secondaryTypes) {
                types.addAll(this.getSessionFacade().getPropertiesFor(secondaryType));
            }
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!types.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public CmisObject createNode(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "cmis:name");
        Message message = exchange.getIn();
        String parentFolderId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder parentFolder = (Folder)this.getSessionFacade().getObjectById(parentFolderId);
        Map<String, Object> cmisProperties = this.filterTypeProperties(message.getHeaders());
        if (this.isDocument(exchange)) {
            String fileName = (String)message.getHeader("cmis:name", String.class);
            String mimeType = this.getMimeType(message);
            byte[] buf = this.getBodyData(message);
            ContentStream contentStream = this.getSessionFacade().createContentStream(fileName, buf, mimeType);
            return this.storeDocument(parentFolder, cmisProperties, contentStream);
        }
        if (this.isFolder(message)) {
            return this.storeFolder(parentFolder, cmisProperties);
        }
        return this.storeDocument(parentFolder, cmisProperties, null);
    }

    public List<String> deleteFolder(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder folder = (Folder)this.getSessionFacade().getObjectById(objectId);
        return folder.deleteTree(true, UnfileObject.DELETE, true);
    }

    public void deleteDocument(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        document.deleteAllVersions();
    }

    public void moveDocument(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISDestinationFolderId");
        this.validateRequiredHeader(exchange, "CamelCMISSourceFolderId");
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String destinationFolderId = (String)message.getHeader("CamelCMISDestinationFolderId", String.class);
        String sourceFolderId = (String)message.getHeader("CamelCMISSourceFolderId", String.class);
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder sourceFolder = (Folder)this.getSessionFacade().getObjectById(sourceFolderId);
        Folder targetFolder = (Folder)this.getSessionFacade().getObjectById(destinationFolderId);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        if (document != null) {
            if (!document.getAllowableActions().getAllowableActions().contains(Action.CAN_MOVE_OBJECT)) {
                throw new CamelCmisUnauthorizedException("Current user does not have permission to move " + objectId + document.getName());
            }
            try {
                document.move((ObjectId)sourceFolder, (ObjectId)targetFolder);
                this.log.info("Moved document from " + sourceFolder.getName() + " to " + targetFolder.getName());
            }
            catch (Exception e) {
                throw new CamelCmisException("Cannot move document to folder " + targetFolder.getName() + " : " + e.getMessage(), e);
            }
        } else {
            this.log.error("Document is null, cannot move!");
        }
    }

    public Map<String, String> moveFolder(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISDestinationFolderId");
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String destinationFolderId = (String)message.getHeader("CamelCMISDestinationFolderId", String.class);
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder toBeMoved = (Folder)this.getSessionFacade().getObjectById(objectId);
        Folder targetFolder = (Folder)this.getSessionFacade().getObjectById(destinationFolderId);
        Map<String, String> folders = this.copyFolderRecursive(targetFolder, toBeMoved);
        toBeMoved.deleteTree(true, UnfileObject.DELETE, true);
        return folders;
    }

    public Document copyDocument(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        this.validateRequiredHeader(exchange, "CamelCMISDestinationFolderId");
        Message message = exchange.getIn();
        String destinationFolderId = (String)message.getHeader("CamelCMISDestinationFolderId", String.class);
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder destinationFolder = (Folder)this.getSessionFacade().getObjectById(destinationFolderId);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        return document.copy((ObjectId)destinationFolder);
    }

    public Map<String, String> copyFolder(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISDestinationFolderId");
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String destinationFolderId = (String)message.getHeader("CamelCMISDestinationFolderId", String.class);
        String toCopyFolderId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Folder destinationFolder = (Folder)this.getSessionFacade().getObjectById(destinationFolderId);
        Folder toCopyFolder = (Folder)this.getSessionFacade().getObjectById(toCopyFolderId);
        return this.copyFolderRecursive(destinationFolder, toCopyFolder);
    }

    private Map<String, String> copyFolderRecursive(Folder destinationFolder, Folder toCopyFolder) {
        HashMap<String, String> folderProperties = new HashMap<String, String>();
        folderProperties.put("cmis:name", toCopyFolder.getName());
        folderProperties.put("cmis:objectTypeId", toCopyFolder.getBaseTypeId().value());
        HashMap<String, String> folders = new HashMap<String, String>();
        Folder newFolder = destinationFolder.createFolder(folderProperties);
        folders.put(toCopyFolder.getId(), newFolder.getId());
        this.copyChildren(newFolder, toCopyFolder);
        return folders;
    }

    private void copyChildren(Folder destinationFolder, Folder toCopyFolder) {
        ItemIterable immediateChildren = toCopyFolder.getChildren();
        for (CmisObject child : immediateChildren) {
            if (child instanceof Document) {
                ((Document)child).copy((ObjectId)destinationFolder);
                continue;
            }
            if (!(child instanceof Folder)) continue;
            this.copyFolderRecursive(destinationFolder, (Folder)child);
        }
    }

    public CmisObject rename(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "cmis:name");
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String newName = (String)message.getHeader("cmis:name", String.class);
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        try {
            CmisObject object = this.getSessionFacade().getObjectById(objectId);
            CmisObject object1 = object.rename(newName);
            return object;
        }
        catch (Exception e) {
            throw new CamelCmisObjectNotFoundException("Object with id: " + objectId + " can not be found!");
        }
    }

    public void checkIn(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        String checkInComment = (String)message.getHeader("cmis:checkinComment", String.class);
        String fileName = (String)message.getHeader("cmis:name", String.class);
        String mimeType = this.getMimeType(message);
        InputStream inputStream = (InputStream)message.getBody();
        byte[] bytes = (byte[])message.getBody(byte[].class);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        Map<String, Object> properties = this.filterTypeProperties(message.getHeaders());
        ContentStream contentStream = this.getSessionFacade().createContentStream(fileName, bytes, mimeType);
        document.checkIn(true, properties, contentStream, checkInComment);
    }

    public void checkOut(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        document.checkOut();
    }

    public void cancelCheckOut(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "CamelCMISObjectId");
        Message message = exchange.getIn();
        String objectId = (String)message.getHeader("CamelCMISObjectId", String.class);
        Document document = (Document)this.getSessionFacade().getObjectById(objectId);
        document.cancelCheckOut();
    }

    private boolean isFolder(Message message) throws Exception {
        String baseTypeId = (String)message.getHeader("cmis:objectTypeId", String.class);
        if (baseTypeId != null) {
            return "cmis:folder".equals(this.getSessionFacade().getCMISTypeFor(baseTypeId));
        }
        return message.getBody() == null;
    }

    private Folder storeFolder(Folder parentFolder, Map<String, Object> cmisProperties) throws Exception {
        if (!cmisProperties.containsKey("cmis:objectTypeId")) {
            cmisProperties.put("cmis:objectTypeId", "cmis:folder");
        }
        this.log.debug("Creating folder with properties: {}", cmisProperties);
        return parentFolder.createFolder(cmisProperties);
    }

    private Document storeDocument(Folder parentFolder, Map<String, Object> cmisProperties, ContentStream contentStream) throws Exception {
        if (!cmisProperties.containsKey("cmis:objectTypeId")) {
            cmisProperties.put("cmis:objectTypeId", "cmis:document");
        }
        VersioningState versioningState = VersioningState.NONE;
        if (this.getSessionFacade().isObjectTypeVersionable((String)cmisProperties.get("cmis:objectTypeId"))) {
            versioningState = VersioningState.MAJOR;
        }
        this.log.debug("Creating document with properties: {}", cmisProperties);
        return parentFolder.createDocument(cmisProperties, contentStream, versioningState);
    }

    private void validateRequiredHeader(Exchange exchange, String name) throws NoSuchHeaderException {
        ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)name, String.class);
    }

    private boolean isDocument(Exchange exchange) throws Exception {
        String baseTypeId = (String)exchange.getIn().getHeader("cmis:objectTypeId", String.class);
        if (baseTypeId != null) {
            return "cmis:document".equals(this.getSessionFacade().getCMISTypeFor(baseTypeId));
        }
        return exchange.getIn().getBody() != null;
    }

    private byte[] getBodyData(Message message) {
        return (byte[])message.getBody(byte[].class);
    }

    private String getMimeType(Message message) throws NoSuchHeaderException {
        String mimeType = (String)message.getHeader("cmis:contentStreamMimeType", String.class);
        if (mimeType == null) {
            mimeType = MessageHelper.getContentType((Message)message);
        }
        return mimeType;
    }

    private CMISSessionFacade getSessionFacade() throws Exception {
        if (this.sessionFacade == null) {
            CMISSessionFacade sessionFacade = this.sessionFacadeFactory.create(this.getEndpoint());
            sessionFacade.initSession();
            this.sessionFacade = sessionFacade;
        }
        return this.sessionFacade;
    }
}

