/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.flink.annotations.DataSetCallback;
import org.apache.camel.util.ObjectHelper;
import org.apache.flink.api.java.DataSet;

public class AnnotatedDataSetCallback
implements org.apache.camel.component.flink.DataSetCallback {
    private final Object objectWithCallback;
    private final List<Method> dataSetCallbacks;
    private final CamelContext camelContext;

    public AnnotatedDataSetCallback(Object objectWithCallback, CamelContext camelContext) {
        this.objectWithCallback = objectWithCallback;
        this.camelContext = camelContext;
        this.dataSetCallbacks = ObjectHelper.findMethodsWithAnnotation(objectWithCallback.getClass(), DataSetCallback.class);
        if (this.dataSetCallbacks.size() == 0) {
            throw new UnsupportedOperationException("Can't find methods annotated with @DataSetCallback");
        }
    }

    public AnnotatedDataSetCallback(Object objectWithCallback) {
        this(objectWithCallback, null);
    }

    public Object onDataSet(DataSet ds, Object ... payloads) {
        try {
            ArrayList<Object> arguments = new ArrayList<Object>(payloads.length + 1);
            arguments.add(ds);
            arguments.addAll(Arrays.asList(payloads));
            if (arguments.get(1) == null) {
                arguments.remove(1);
            }
            Method callbackMethod = this.dataSetCallbacks.get(0);
            if (this.camelContext != null) {
                for (int i = 1; i < arguments.size(); ++i) {
                    arguments.set(i, this.camelContext.getTypeConverter().convertTo(callbackMethod.getParameterTypes()[i], arguments.get(i)));
                }
            }
            Object[] args = arguments.toArray(new Object[arguments.size()]);
            return org.apache.camel.support.ObjectHelper.invokeMethodSafe((Method)callbackMethod, (Object)this.objectWithCallback, (Object[])args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

