/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.KeyedDataQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400DataQueueService;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.support.DefaultProducer;

public class Jt400DataQueueProducer
extends DefaultProducer {
    private final Jt400Endpoint endpoint;
    private final Jt400DataQueueService queueService;

    protected Jt400DataQueueProducer(Jt400Endpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.queueService = new Jt400DataQueueService(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        BaseDataQueue queue = this.queueService.getDataQueue();
        if (this.endpoint.isKeyed()) {
            this.process((KeyedDataQueue)queue, exchange);
        } else {
            this.process((DataQueue)queue, exchange);
        }
    }

    private void process(DataQueue queue, Exchange exchange) throws Exception {
        if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
            queue.write((byte[])exchange.getIn().getBody(byte[].class));
        } else {
            queue.write((String)exchange.getIn().getBody(String.class));
        }
    }

    private void process(KeyedDataQueue queue, Exchange exchange) throws Exception {
        if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
            queue.write((byte[])exchange.getIn().getHeader("KEY", byte[].class), (byte[])exchange.getIn().getBody(byte[].class));
        } else {
            queue.write((String)exchange.getIn().getHeader("KEY", String.class), (String)exchange.getIn().getBody(String.class));
        }
    }

    protected void doStart() throws Exception {
        this.queueService.start();
    }

    protected void doStop() throws Exception {
        this.queueService.stop();
    }
}

