/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.google.sheets.BatchGoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsVerifierExtension;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="google-sheets-stream")
public class GoogleSheetsStreamComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private Sheets client;
    @Metadata(label="advanced")
    private GoogleSheetsClientFactory clientFactory;
    @Metadata
    private GoogleSheetsStreamConfiguration configuration;

    public GoogleSheetsStreamComponent() {
        this(null);
    }

    public GoogleSheetsStreamComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new GoogleSheetsVerifierExtension("google-sheets-stream", context));
        this.configuration = new GoogleSheetsStreamConfiguration();
    }

    public Sheets getClient(GoogleSheetsStreamConfiguration endpointConfiguration) {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(endpointConfiguration.getClientId(), endpointConfiguration.getClientSecret(), endpointConfiguration.getApplicationName(), endpointConfiguration.getRefreshToken(), endpointConfiguration.getAccessToken());
        }
        return this.client;
    }

    public GoogleSheetsClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleSheetsClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleSheetsStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleSheetsStreamConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GoogleSheetsStreamConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        GoogleSheetsStreamEndpoint endpoint = new GoogleSheetsStreamEndpoint(uri, this, configuration);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }
}

