/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.PreConsumed;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaConsumer
extends ScheduledBatchPollingConsumer {
    private static final Map<String, Object> NOWAIT = new HashMap<String, Object>();
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionTemplate transactionTemplate;
    private EntityManager entityManager;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private DeleteHandler<Object> preDeleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private LockModeType lockModeType = LockModeType.PESSIMISTIC_WRITE;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private boolean transacted;
    private boolean skipLockedEntity;

    public JpaConsumer(JpaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        if (this.entityManager == null) {
            this.entityManager = this.getEndpoint().isSharedEntityManager() ? SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.entityManagerFactory) : this.entityManagerFactory.createEntityManager();
            this.log.trace("Recreated EntityManager {} on {}", (Object)this.entityManager, (Object)this);
        }
        Object messagePolled = null;
        try {
            messagePolled = this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    if (JpaConsumer.this.getEndpoint().isJoinTransaction()) {
                        JpaConsumer.this.entityManager.joinTransaction();
                    }
                    LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
                    Query query = JpaConsumer.this.getQueryFactory().createQuery(JpaConsumer.this.entityManager);
                    JpaConsumer.this.configureParameters(query);
                    JpaConsumer.this.log.trace("Created query {}", (Object)query);
                    List results = query.getResultList();
                    JpaConsumer.this.log.trace("Got result list from query {}", (Object)results);
                    for (Object result : results) {
                        DataHolder holder = new DataHolder();
                        holder.manager = JpaConsumer.this.entityManager;
                        holder.result = result;
                        holder.exchange = JpaConsumer.this.createExchange(result, JpaConsumer.this.entityManager);
                        answer.add(holder);
                    }
                    PersistenceException cause = null;
                    int messagePolled = 0;
                    try {
                        messagePolled = JpaConsumer.this.processBatch(CastUtils.cast(answer));
                    }
                    catch (Exception e) {
                        cause = e instanceof PersistenceException ? (PersistenceException)e : new PersistenceException((Throwable)e);
                    }
                    if (cause != null) {
                        if (!JpaConsumer.this.isTransacted()) {
                            JpaConsumer.this.log.warn("Error processing last message due: {}. Will commit all previous successful processed message, and ignore this last failure.", (Object)cause.getMessage(), (Object)cause);
                        } else {
                            throw cause;
                        }
                    }
                    JpaConsumer.this.log.debug("Flushing EntityManager");
                    JpaConsumer.this.entityManager.flush();
                    JpaConsumer.this.entityManager.clear();
                    return messagePolled;
                }
            });
        }
        catch (Exception e) {
            this.log.debug("Disposing EntityManager {} on {} due to coming transaction rollback", (Object)this.entityManager, (Object)this);
            this.entityManager.close();
            this.entityManager = null;
            throw new PersistenceException((Throwable)e);
        }
        return (Integer)this.getEndpoint().getCamelContext().getTypeConverter().convertTo(Integer.TYPE, messagePolled);
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            this.log.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there were " + total + " messages in this poll.");
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
            EntityManager entityManager = holder.manager;
            Exchange exchange = holder.exchange;
            Object result = holder.result;
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            if (!this.lockEntity(result, entityManager)) continue;
            this.createPreDeleteHandler().deleteObject(entityManager, result, exchange);
            this.log.debug("Processing exchange: {}", (Object)exchange);
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            this.getDeleteHandler().deleteObject(entityManager, result, exchange);
        }
        return total;
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler<Object> getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<Object> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public DeleteHandler<Object> getPreDeleteHandler() {
        if (this.preDeleteHandler == null) {
            this.preDeleteHandler = this.createPreDeleteHandler();
        }
        return this.preDeleteHandler;
    }

    public void setPreDeleteHandler(DeleteHandler<Object> preDeleteHandler) {
        this.preDeleteHandler = preDeleteHandler;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setSkipLockedEntity(boolean skipLockedEntity) {
        this.skipLockedEntity = skipLockedEntity;
    }

    public boolean isSkipLockedEntity() {
        return this.skipLockedEntity;
    }

    protected boolean lockEntity(Object entity, EntityManager entityManager) {
        if (!this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            this.log.debug("Acquiring exclusive lock on entity: {}", entity);
            if (this.isSkipLockedEntity()) {
                entityManager.lock(entity, this.lockModeType, NOWAIT);
            } else {
                entityManager.lock(entity, this.lockModeType);
            }
            return true;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to achieve lock on entity: " + entity + ". Reason: " + e, (Throwable)e);
            }
            if (e instanceof PessimisticLockException || e instanceof OptimisticLockException) {
                throw (PersistenceException)e;
            }
            return entity.getClass().isArray();
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            if (this.resultClass != null) {
                return QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass);
            }
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType == null) {
            return null;
        }
        String name = this.getEntityName(entityType);
        if (name != null) {
            return QueryBuilder.query("select x from " + name + " x");
        }
        return QueryBuilder.query("select x from " + entityType.getSimpleName() + " x");
    }

    protected String getEntityName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().equals("")) {
            return entity.name();
        }
        return null;
    }

    protected DeleteHandler<Object> createPreDeleteHandler() {
        final Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, PreConsumed.class);
            if (methods.size() > 1) {
                throw new IllegalStateException("Only one method can be annotated with the @PreConsumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = (Method)methods.get(0);
                final boolean useExchangeParameter = this.checkParameters(method);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean, Exchange exchange) {
                        if (entityType.isInstance(entityBean)) {
                            if (useExchangeParameter) {
                                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[]{exchange});
                            } else {
                                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                            }
                        }
                    }
                };
            }
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean, Exchange exchange) {
            }
        };
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        final Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = (Method)methods.get(0);
                final boolean useExchangeParameter = this.checkParameters(method);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean, Exchange exchange) {
                        if (entityType.isInstance(entityBean)) {
                            if (useExchangeParameter) {
                                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[]{exchange});
                            } else {
                                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                            }
                        }
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return new DeleteHandler<Object>(){

                @Override
                public void deleteObject(EntityManager entityManager, Object entityBean, Exchange exchange) {
                    entityManager.remove(entityBean);
                }
            };
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean, Exchange exchange) {
            }
        };
    }

    protected boolean checkParameters(Method method) {
        boolean result = false;
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1 && parameters[0].isAssignableFrom(Exchange.class)) {
            result = true;
        }
        if (parameters.length > 0 && !result) {
            throw new IllegalStateException("@PreConsumed annotated method cannot have parameter other than Exchange");
        }
        return result;
    }

    protected void configureParameters(Query query) {
        int maxResults = this.getEndpoint().getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Exchange createExchange(Object result, EntityManager entityManager) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(result);
        exchange.getIn().setHeader("CamelEntityManager", (Object)entityManager);
        return exchange;
    }

    protected void doStart() throws Exception {
        this.entityManager = this.getEndpoint().isSharedEntityManager() ? SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.entityManagerFactory) : this.entityManagerFactory.createEntityManager();
        this.log.trace("Created EntityManager {} on {}", (Object)this.entityManager, (Object)this);
        super.doStart();
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        if (this.entityManager != null) {
            this.entityManager.close();
            this.log.trace("Closed EntityManager {} on {}", (Object)this.entityManager, (Object)this);
        }
        super.doShutdown();
    }

    static {
        NOWAIT.put("javax.persistence.lock.timeout", 0L);
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object result;
        private EntityManager manager;

        private DataHolder() {
        }
    }
}

