/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.kinesis.KinesisEndpoint;
import org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class KinesisEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return KinesisEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return KinesisEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "accessKey": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonKinesisClient": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setAmazonKinesisClient((AmazonKinesis)KinesisEndpointConfigurer.property((CamelContext)camelContext, AmazonKinesis.class, (Object)value));
                return true;
            }
            case "maxResultsPerRequest": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setMaxResultsPerRequest((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "iteratorType": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setIteratorType((ShardIteratorType)KinesisEndpointConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "shardId": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setShardId((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequenceNumber": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setSequenceNumber((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shardClosed": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setShardClosed((KinesisShardClosedStrategyEnum)((Object)KinesisEndpointConfigurer.property((CamelContext)camelContext, KinesisShardClosedStrategyEnum.class, (Object)value)));
                return true;
            }
            case "proxyHost": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((KinesisEndpoint)((Object)endpoint)).setStartScheduler((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((KinesisEndpoint)((Object)endpoint)).setInitialDelay((Long)KinesisEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((KinesisEndpoint)((Object)endpoint)).setDelay((Long)KinesisEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((KinesisEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)KinesisEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((KinesisEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((KinesisEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)KinesisEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((KinesisEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)KinesisEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((KinesisEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((KinesisEndpoint)((Object)endpoint)).setGreedy((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((KinesisEndpoint)((Object)endpoint)).setScheduler((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((KinesisEndpoint)((Object)endpoint)).setSchedulerProperties((Map)KinesisEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((KinesisEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)KinesisEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((KinesisEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((KinesisEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((KinesisEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KinesisEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((KinesisEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KinesisEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KinesisEndpoint)((Object)endpoint)).setSynchronous((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((KinesisEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "accesskey": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisclient": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setAmazonKinesisClient((AmazonKinesis)KinesisEndpointConfigurer.property((CamelContext)camelContext, AmazonKinesis.class, (Object)value));
                return true;
            }
            case "maxresultsperrequest": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setMaxResultsPerRequest((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "iteratortype": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setIteratorType((ShardIteratorType)KinesisEndpointConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "shardid": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setShardId((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumber": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setSequenceNumber((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shardclosed": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setShardClosed((KinesisShardClosedStrategyEnum)((Object)KinesisEndpointConfigurer.property((CamelContext)camelContext, KinesisShardClosedStrategyEnum.class, (Object)value)));
                return true;
            }
            case "proxyhost": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((KinesisEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((KinesisEndpoint)((Object)endpoint)).setStartScheduler((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((KinesisEndpoint)((Object)endpoint)).setInitialDelay((Long)KinesisEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((KinesisEndpoint)((Object)endpoint)).setDelay((Long)KinesisEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((KinesisEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)KinesisEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((KinesisEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((KinesisEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)KinesisEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((KinesisEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)KinesisEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((KinesisEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((KinesisEndpoint)((Object)endpoint)).setGreedy((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((KinesisEndpoint)((Object)endpoint)).setScheduler((String)KinesisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((KinesisEndpoint)((Object)endpoint)).setSchedulerProperties((Map)KinesisEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((KinesisEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)KinesisEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((KinesisEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)KinesisEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((KinesisEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((KinesisEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((KinesisEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KinesisEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((KinesisEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KinesisEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KinesisEndpoint)((Object)endpoint)).setSynchronous((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((KinesisEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KinesisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

