/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.sdb.SdbEndpoint;
import org.apache.camel.component.aws.sdb.SdbOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SdbEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return SdbEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return SdbEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonSDBClient": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setAmazonSDBClient((AmazonSimpleDB)SdbEndpointConfigurer.property((CamelContext)camelContext, AmazonSimpleDB.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxNumberOfDomains": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setMaxNumberOfDomains((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "consistentRead": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setConsistentRead((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setOperation((SdbOperations)((Object)SdbEndpointConfigurer.property((CamelContext)camelContext, SdbOperations.class, (Object)value)));
                return true;
            }
            case "proxyHost": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((SdbEndpoint)((Object)endpoint)).setStartScheduler((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((SdbEndpoint)((Object)endpoint)).setInitialDelay((Long)SdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((SdbEndpoint)((Object)endpoint)).setDelay((Long)SdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((SdbEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)SdbEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((SdbEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((SdbEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)SdbEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((SdbEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)SdbEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((SdbEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((SdbEndpoint)((Object)endpoint)).setGreedy((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((SdbEndpoint)((Object)endpoint)).setScheduler((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((SdbEndpoint)((Object)endpoint)).setSchedulerProperties((Map)SdbEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((SdbEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)SdbEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((SdbEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((SdbEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((SdbEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SdbEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((SdbEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SdbEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SdbEndpoint)((Object)endpoint)).setSynchronous((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((SdbEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazonsdbclient": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setAmazonSDBClient((AmazonSimpleDB)SdbEndpointConfigurer.property((CamelContext)camelContext, AmazonSimpleDB.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxnumberofdomains": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setMaxNumberOfDomains((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "consistentread": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setConsistentRead((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setOperation((SdbOperations)((Object)SdbEndpointConfigurer.property((CamelContext)camelContext, SdbOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((SdbEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((SdbEndpoint)((Object)endpoint)).setStartScheduler((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((SdbEndpoint)((Object)endpoint)).setInitialDelay((Long)SdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((SdbEndpoint)((Object)endpoint)).setDelay((Long)SdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((SdbEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)SdbEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((SdbEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((SdbEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)SdbEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((SdbEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)SdbEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((SdbEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((SdbEndpoint)((Object)endpoint)).setGreedy((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((SdbEndpoint)((Object)endpoint)).setScheduler((String)SdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((SdbEndpoint)((Object)endpoint)).setSchedulerProperties((Map)SdbEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((SdbEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)SdbEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((SdbEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)SdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((SdbEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((SdbEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((SdbEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SdbEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((SdbEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SdbEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SdbEndpoint)((Object)endpoint)).setSynchronous((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((SdbEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

