/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class GetAttributesCommand
extends AbstractSdbCommand {
    public GetAttributesCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        GetAttributesRequest request = new GetAttributesRequest().withDomainName(this.determineDomainName()).withItemName(this.determineItemName()).withConsistentRead(this.determineConsistentRead()).withAttributeNames(this.determineAttributeNames());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        GetAttributesResult result = this.sdbClient.getAttributes(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message msg = GetAttributesCommand.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsSdbAttributes", (Object)result.getAttributes());
    }

    protected Collection<String> determineAttributeNames() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsSdbAttributeNames", Collection.class);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

